/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.client.LazyDomElement;
import com.google.gwt.uibinder.elementparsers.HtmlPlaceholderInterpreter;
import com.google.gwt.uibinder.elementparsers.TextPlaceholderInterpreter;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class WidgetPlaceholderInterpreter
extends HtmlPlaceholderInterpreter {
    private final FieldManager fieldManager;
    private int serial = 0;
    private final String ancestorExpression;
    private final String fieldName;
    private final Map<String, XMLElement> idToWidgetElement = new HashMap<String, XMLElement>();
    private final Set<String> idIsHasHTML = new HashSet<String>();
    private final Set<String> idIsHasText = new HashSet<String>();

    WidgetPlaceholderInterpreter(String fieldName, UiBinderWriter writer, MessageWriter message, String ancestorExpression) {
        super(writer, message, ancestorExpression);
        this.fieldName = fieldName;
        this.ancestorExpression = ancestorExpression;
        this.fieldManager = this.uiWriter.getFieldManager();
    }

    @Override
    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (!this.uiWriter.isWidgetElement(elem)) {
            return super.interpretElement(elem);
        }
        JClassType type = this.uiWriter.findFieldType(elem);
        TypeOracle oracle = this.uiWriter.getOracle();
        MessagesWriter mw = this.uiWriter.getMessages();
        String name = mw.consumeMessageAttribute("ph", elem);
        if ("".equals(name)) {
            int n = ++this.serial;
            name = new StringBuilder(17).append("widget").append(n).toString();
        }
        String idHolder = this.uiWriter.declareDomIdHolder(null);
        this.idToWidgetElement.put(idHolder, elem);
        if (oracle.findType(HasHTML.class.getName()).isAssignableFrom(type)) {
            return this.handleHasHTMLPlaceholder(elem, name, idHolder);
        }
        if (oracle.findType(HasText.class.getName()).isAssignableFrom(type)) {
            return this.handleHasTextPlaceholder(elem, name, idHolder);
        }
        return this.handleOpaqueWidgetPlaceholder(elem, name, idHolder);
    }

    public String postProcess(String consumed) throws UnableToCompleteException {
        FieldWriter fieldWriter = this.fieldManager.require(this.fieldName);
        for (String idHolder : this.idToWidgetElement.keySet()) {
            XMLElement childElem = this.idToWidgetElement.get(idHolder);
            FieldWriter childFieldWriter = this.uiWriter.parseElementToField(childElem);
            this.genSetWidgetTextCall(idHolder, childFieldWriter.getName());
            if (this.uiWriter.useLazyWidgetBuilders()) {
                String lazyDomElementPath = LazyDomElement.class.getCanonicalName();
                String elementPointer = String.valueOf(idHolder).concat("Element");
                FieldWriter elementWriter = this.fieldManager.registerField(lazyDomElementPath, elementPointer);
                elementWriter.setInitializer(String.format("new %s<Element>(%s)", lazyDomElementPath, this.fieldManager.convertFieldToGetter(idHolder)));
                fieldWriter.addAttachStatement("%s.get();", new Object[]{this.fieldManager.convertFieldToGetter(elementPointer)});
                fieldWriter.addDetachStatement("%s.addAndReplaceElement(%s, %s.get());", new Object[]{this.fieldName, this.fieldManager.convertFieldToGetter(childFieldWriter.getName()), this.fieldManager.convertFieldToGetter(elementPointer)});
                continue;
            }
            this.uiWriter.addInitStatement("%1$s.addAndReplaceElement(%2$s, %3$s);", new Object[]{this.fieldName, childFieldWriter.getName(), idHolder});
        }
        this.idToWidgetElement.clear();
        return super.postProcess(consumed);
    }

    private String genCloseTag(String name) {
        String closePlaceholder = this.nextClosePlaceholder(String.valueOf(name).concat("End"), "</span>");
        return closePlaceholder;
    }

    private String genOpenTag(XMLElement source, String name, String idHolder) {
        idHolder = this.fieldManager.convertFieldToGetter(idHolder);
        if (this.uiWriter.useSafeHtmlTemplates()) {
            idHolder = this.uiWriter.tokenForStringExpression(source, idHolder);
        } else {
            String string = idHolder;
            idHolder = new StringBuilder(8 + String.valueOf(string).length()).append("\" + ").append(string).append(" + \"").toString();
        }
        String openTag = String.format("<span id='%s'>", idHolder);
        String openPlaceholder = this.nextOpenPlaceholder(String.valueOf(name).concat("Begin"), openTag);
        return openPlaceholder;
    }

    private void genSetWidgetTextCall(String idHolder, String childField) {
        if (this.uiWriter.useLazyWidgetBuilders()) {
            if (this.idIsHasText.contains(idHolder)) {
                this.fieldManager.require(this.fieldName).addAttachStatement("%s.setText(%s.getElementById(%s).getInnerText());", new Object[]{this.fieldManager.convertFieldToGetter(childField), this.fieldName, this.fieldManager.convertFieldToGetter(idHolder)});
            } else if (this.idIsHasHTML.contains(idHolder)) {
                this.fieldManager.require(this.fieldName).addAttachStatement("%s.setHTML(%s.getElementById(%s).getInnerHTML());", new Object[]{this.fieldManager.convertFieldToGetter(childField), this.fieldName, this.fieldManager.convertFieldToGetter(idHolder)});
            }
        } else {
            if (this.idIsHasText.contains(idHolder)) {
                this.uiWriter.addInitStatement("%s.setText(%s.getElementById(%s).getInnerText());", new Object[]{childField, this.fieldName, idHolder});
            }
            if (this.idIsHasHTML.contains(idHolder)) {
                this.uiWriter.addInitStatement("%s.setHTML(%s.getElementById(%s).getInnerHTML());", new Object[]{childField, this.fieldName, idHolder});
            }
        }
    }

    private String handleHasHTMLPlaceholder(XMLElement elem, String name, String idHolder) throws UnableToCompleteException {
        this.idIsHasHTML.add(idHolder);
        String openPlaceholder = this.genOpenTag(elem, name, idHolder);
        String body = elem.consumeInnerHtml((XMLElement.PostProcessingInterpreter)new HtmlPlaceholderInterpreter(this.uiWriter, this.message, this.ancestorExpression));
        String bodyToken = this.tokenator.nextToken(body);
        String closePlaceholder = this.genCloseTag(name);
        return new StringBuilder(0 + String.valueOf(openPlaceholder).length() + String.valueOf(bodyToken).length() + String.valueOf(closePlaceholder).length()).append(openPlaceholder).append(bodyToken).append(closePlaceholder).toString();
    }

    private String handleHasTextPlaceholder(XMLElement elem, String name, String idHolder) throws UnableToCompleteException {
        this.idIsHasText.add(idHolder);
        String openPlaceholder = this.genOpenTag(elem, name, idHolder);
        String body = elem.consumeInnerText((XMLElement.PostProcessingInterpreter)new TextPlaceholderInterpreter(this.uiWriter, this.message));
        String bodyToken = this.tokenator.nextToken(body);
        String closePlaceholder = this.genCloseTag(name);
        return new StringBuilder(0 + String.valueOf(openPlaceholder).length() + String.valueOf(bodyToken).length() + String.valueOf(closePlaceholder).length()).append(openPlaceholder).append(bodyToken).append(closePlaceholder).toString();
    }

    private String handleOpaqueWidgetPlaceholder(XMLElement source, String name, String idHolder) {
        idHolder = this.fieldManager.convertFieldToGetter(idHolder);
        if (this.uiWriter.useSafeHtmlTemplates()) {
            idHolder = this.uiWriter.tokenForStringExpression(source, idHolder);
        } else {
            String string = idHolder;
            idHolder = new StringBuilder(8 + String.valueOf(string).length()).append("\" + ").append(string).append(" + \"").toString();
        }
        String tag = String.format("<span id='%s'></span>", idHolder);
        String placeholder = this.nextPlaceholder(name, "<span></span>", tag);
        return placeholder;
    }
}

