/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.SafeUriHostedModeUtils;
import com.google.gwt.safehtml.shared.SafeUriString;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public final class UriUtils {
    static final String DONT_NEED_ENCODING = ";/?:@&=+$,-_.!~*'()#[]";
    private static final RegExp ESCAPED_LBRACKET_RE = GWT.isScript() ? RegExp.compile("%5B", "g") : null;
    private static final RegExp ESCAPED_RBRACKET_RE = GWT.isScript() ? RegExp.compile("%5D", "g") : null;

    public static String encode(String uri) {
        byte[] utf8bytes;
        if (GWT.isScript()) {
            if ((uri = URL.encode(uri)).indexOf("%5B") != -1) {
                uri = ESCAPED_LBRACKET_RE.replace(uri, "[");
            }
            if (uri.indexOf("%5D") != -1) {
                uri = ESCAPED_RBRACKET_RE.replace(uri, "]");
            }
            return uri;
        }
        StringBuilder sb = new StringBuilder();
        try {
            utf8bytes = uri.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        for (byte b : utf8bytes) {
            int c = b & 0xFF;
            if (97 <= c && c <= 122 || 65 <= c && c <= 90 || 48 <= c && c <= 57 || DONT_NEED_ENCODING.indexOf(c) != -1) {
                sb.append((char)c);
                continue;
            }
            String hexByte = Integer.toHexString(c).toUpperCase(Locale.ROOT);
            if (hexByte.length() == 1) {
                String string = String.valueOf(hexByte);
                hexByte = string.length() != 0 ? "0".concat(string) : new String("0");
            }
            sb.append('%').append(hexByte);
        }
        return sb.toString();
    }

    public static String encodeAllowEscapes(String uri) {
        StringBuilder escaped = new StringBuilder();
        boolean firstSegment = true;
        for (String segment : uri.split("%", -1)) {
            if (firstSegment) {
                firstSegment = false;
                escaped.append(UriUtils.encode(segment));
                continue;
            }
            if (segment.length() >= 2 && segment.substring(0, 2).matches("[0-9a-fA-F]{2}")) {
                escaped.append("%").append(segment.substring(0, 2));
                escaped.append(UriUtils.encode(segment.substring(2)));
                continue;
            }
            escaped.append("%25").append(UriUtils.encode(segment));
        }
        return escaped.toString();
    }

    public static String extractScheme(String uri) {
        int colonPos = uri.indexOf(58);
        if (colonPos < 0) {
            return null;
        }
        String scheme = uri.substring(0, colonPos);
        if (scheme.indexOf(47) >= 0 || scheme.indexOf(35) >= 0) {
            return null;
        }
        return scheme;
    }

    public static SafeUri fromSafeConstant(String s) {
        SafeUriHostedModeUtils.maybeCheckValidUri(s);
        return new SafeUriString(s);
    }

    public static SafeUri fromString(String s) {
        return new SafeUriString(UriUtils.sanitizeUri(s));
    }

    public static SafeUri fromTrustedString(String s) {
        SafeUriHostedModeUtils.maybeCheckValidUri(s);
        return new SafeUriString(s);
    }

    public static boolean isSafeUri(String uri) {
        String scheme = UriUtils.extractScheme(uri);
        if (scheme == null) {
            return true;
        }
        String schemeLc = scheme.toLowerCase(Locale.ROOT);
        return "http".equals(schemeLc) || "https".equals(schemeLc) || "ftp".equals(schemeLc) || "mailto".equals(schemeLc) || "MAILTO".equals(scheme.toUpperCase(Locale.ROOT));
    }

    public static String sanitizeUri(String uri) {
        if (UriUtils.isSafeUri(uri)) {
            return UriUtils.encodeAllowEscapes(uri);
        }
        return "#";
    }

    @Deprecated
    public static SafeUri unsafeCastFromUntrustedString(String s) {
        return new SafeUriString(s);
    }

    private UriUtils() {
    }
}

