/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.ext.ClientBundleRequirements;

public class RequirementsCollector
extends CssVisitor {
    private final TreeLogger logger;
    private final ClientBundleRequirements requirements;

    public RequirementsCollector(TreeLogger logger, ClientBundleRequirements requirements) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Scanning CSS for requirements");
        this.requirements = requirements;
    }

    @Override
    public void endVisit(CssIf x, Context ctx) {
        String propertyName = x.getPropertyName();
        if (propertyName != null) {
            try {
                this.requirements.addPermutationAxis(propertyName);
            }
            catch (BadPropertyValueException e) {
                String string = String.valueOf(propertyName);
                this.logger.log(TreeLogger.ERROR, string.length() != 0 ? "Unknown deferred-binding property ".concat(string) : new String("Unknown deferred-binding property "), (Throwable)e);
                throw new CssCompilerException("Unknown deferred-binding property", e);
            }
        }
    }
}

