/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.List;

public class CheckStaticCssVisitor
extends CssVisitor {
    private boolean error;
    private final boolean fastFail;
    private final TreeLogger logger;

    public static boolean isStatic(CssStylesheet sheet) {
        return new CheckStaticCssVisitor(TreeLogger.NULL, true).execImpl(sheet);
    }

    public static boolean report(TreeLogger logger, CssStylesheet sheet) {
        return new CheckStaticCssVisitor(logger, false).execImpl(sheet);
    }

    private CheckStaticCssVisitor(TreeLogger logger, boolean fastFail) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Checking external stylesheet for dynamic content");
        this.fastFail = fastFail;
    }

    @Override
    protected void doAccept(List<? extends CssNode> list) {
        for (CssNode cssNode : list) {
            if (this.error && this.fastFail) {
                return;
            }
            this.doAccept(cssNode);
        }
    }

    @Override
    protected <T extends CssNode> T doAccept(T node) {
        if (!node.isStatic()) {
            this.error(node);
        }
        if (this.error && this.fastFail) {
            return node;
        }
        return super.doAccept(node);
    }

    @Override
    protected void doAcceptWithInsertRemove(List<? extends CssNode> list) {
        this.doAccept((CssNode)((Object)list));
    }

    void error(CssNode node) {
        String string = node.toString();
        this.logger.log(TreeLogger.ERROR, new StringBuilder(44 + String.valueOf(string).length()).append("The CSS node ").append(string).append(" cannot be statically evaluated").toString());
        this.error = true;
    }

    private boolean execImpl(CssStylesheet sheet) {
        this.accept(sheet);
        return !this.error;
    }
}

