/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.BiMap;
import com.google.gwt.thirdparty.guava.common.collect.HashBiMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefCollectorVisitor
extends CssVisitor {
    private static final Pattern INVALID_CHAR = Pattern.compile("[^A-Z0-9_]");
    private int renamingCounter = 0;
    private final BiMap<String, String> defMapping;
    private final List<CssDef> constantNodes;
    private final boolean lenient;
    private final TreeLogger treeLogger;

    public DefCollectorVisitor(boolean lenient, TreeLogger treeLogger) {
        this.lenient = lenient;
        this.treeLogger = treeLogger;
        this.defMapping = HashBiMap.create();
        this.constantNodes = new LinkedList<CssDef>();
    }

    public Map<String, String> getDefMapping() {
        return this.defMapping;
    }

    public List<CssDef> getConstantNodes() {
        return this.constantNodes;
    }

    @Override
    public boolean visit(CssEval x, Context ctx) {
        return this.handleDefNode(x);
    }

    @Override
    public boolean visit(CssDef x, Context ctx) {
        return this.handleDefNode(x);
    }

    @Override
    public boolean visit(CssUrl x, Context ctx) {
        return this.handleDefNode(x);
    }

    private boolean handleDefNode(CssDef def) {
        this.constantNodes.add(def);
        if (!this.defMapping.containsKey(def.getKey())) {
            String string;
            String upperCaseName = this.toUpperCase(def.getKey());
            String validName = INVALID_CHAR.matcher(upperCaseName).replaceAll("_");
            if (!validName.equals(upperCaseName)) {
                string = validName;
                this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(61 + String.valueOf(upperCaseName).length() + String.valueOf(string).length()).append("Invalid characters detected in [").append(upperCaseName).append("]. They have ").append("been replaced [").append(string).append("]").toString());
            }
            if (this.defMapping.containsValue(validName)) {
                if (this.lenient) {
                    string = validName;
                    this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(104 + String.valueOf(string).length()).append("Two constants have the same name [").append(string).append("] ").append("after conversion. The second constant will be renamed automatically.").toString());
                    validName = this.renameConstant(validName);
                } else {
                    string = validName;
                    throw new Css2GssConversionException(new StringBuilder(53 + String.valueOf(string).length()).append("Two constants have the same name [").append(string).append("] after conversion.").toString());
                }
            }
            this.defMapping.forcePut(def.getKey(), validName);
        }
        return false;
    }

    private String renameConstant(String originalName) {
        int n;
        String newName;
        do {
            n = this.renamingCounter++;
        } while (this.defMapping.containsValue(newName = new StringBuilder(22 + String.valueOf(originalName).length()).append(originalName).append("__RENAMED__").append(n).toString()));
        return newName;
    }

    private String toUpperCase(String camelCase) {
        assert (!Strings.isNullOrEmpty(camelCase)) : "camelCase cannot be null or empty";
        if (this.isUpperCase(camelCase)) {
            return camelCase;
        }
        StringBuilder output = new StringBuilder().append(Character.toUpperCase(camelCase.charAt(0)));
        for (int i = 1; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                output.append('_').append(c);
                continue;
            }
            output.append(Character.toUpperCase(c));
        }
        return output.toString();
    }

    private boolean isUpperCase(String camelCase) {
        for (int i = 0; i < camelCase.length(); ++i) {
            if (!Character.isLowerCase(camelCase.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

