/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client.impl;

import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.JUnitResult;
import com.google.gwt.user.client.rpc.RemoteService;
import java.io.Serializable;
import java.util.HashMap;

public interface JUnitHost
extends RemoteService {
    public InitialResponse getTestBlock(int var1, ClientInfo var2) throws TimeoutException;

    public TestBlock reportResultsAndGetTestBlock(HashMap<TestInfo, JUnitResult> var1, int var2, ClientInfo var3) throws TimeoutException;

    public static class TestInfo
    implements Serializable {
        private String testClass;
        private String testMethod;
        private String testModule;

        public TestInfo(String testModule, String testClass, String testMethod) {
            this.testModule = testModule;
            this.testClass = testClass;
            this.testMethod = testMethod;
        }

        TestInfo() {
        }

        public boolean equals(Object o) {
            if (o instanceof TestInfo) {
                TestInfo other = (TestInfo)o;
                return TestInfo.equals(this.testModule, other.testModule) && TestInfo.equals(this.testClass, other.testClass) && TestInfo.equals(this.testMethod, other.testMethod);
            }
            return false;
        }

        private static boolean equals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }

        public String getTestClass() {
            return this.testClass;
        }

        public String getTestMethod() {
            return this.testMethod;
        }

        public String getTestModule() {
            return this.testModule;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            String string = this.testModule;
            String string2 = this.testClass;
            String string3 = this.testMethod;
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(":").append(string2).append(".").append(string3).toString();
        }
    }

    public static class TestBlock
    implements Serializable {
        private int index;
        private TestInfo[] tests;

        public TestBlock(TestInfo[] tests, int index) {
            this.tests = tests;
            this.index = index;
        }

        TestBlock() {
        }

        public int getIndex() {
            return this.index;
        }

        public TestInfo[] getTests() {
            return this.tests;
        }
    }

    public static class InitialResponse
    implements Serializable {
        private int sessionId;
        private TestBlock testBlock;

        public InitialResponse(int sessionId, TestBlock testBlock) {
            this.sessionId = sessionId;
            this.testBlock = testBlock;
        }

        InitialResponse() {
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public TestBlock getTestBlock() {
            return this.testBlock;
        }
    }

    public static class ClientInfo
    implements Serializable {
        private int sessionId;

        public ClientInfo(int sessionId) {
            this.sessionId = sessionId;
        }

        ClientInfo() {
        }

        public int getSessionId() {
            return this.sessionId;
        }
    }
}

