/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.linker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ConfigurationProperty;
import com.google.gwt.core.ext.linker.PropertyProviderGenerator;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.util.SortedSet;
import java.util.regex.Pattern;

public class LocalePropertyProviderGenerator
implements PropertyProviderGenerator {
    public static final String LOCALE_QUERYPARAM = "locale.queryparam";
    public static final String LOCALE_COOKIE = "locale.cookie";
    public static final String LOCALE_SEARCHORDER = "locale.searchorder";
    public static final String LOCALE_USEMETA = "locale.usemeta";
    public static final String LOCALE_USERAGENT = "locale.useragent";
    protected static final Pattern COOKIE_PATTERN = Pattern.compile("^[A-Za-z][A-Za-z0-9_]*$");
    protected static final Pattern QUERYPARAM_PATTERN = Pattern.compile("^[A-Za-z][A-Za-z0-9_]*$");

    protected static boolean isTrue(String value) {
        return value != null && ("yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }

    public String generate(TreeLogger logger, SortedSet<String> possibleValues, String fallback, SortedSet<ConfigurationProperty> configProperties) throws UnableToCompleteException {
        String localeQueryParam = null;
        String localeCookie = null;
        boolean localeUserAgent = false;
        boolean localeUseMeta = false;
        String localeSearchOrder = "queryparam,cookie,meta,useragent";
        for (ConfigurationProperty configProp : configProperties) {
            String string;
            String string2;
            String name = configProp.getName();
            if (LOCALE_QUERYPARAM.equals(name)) {
                localeQueryParam = (String)configProp.getValues().get(0);
                if (localeQueryParam == null || localeQueryParam.length() == 0 || this.validateQueryParam(localeQueryParam)) continue;
                string2 = localeQueryParam;
                string = String.valueOf(LOCALE_QUERYPARAM);
                logger.log(TreeLogger.WARN, new StringBuilder(70 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Ignoring invalid value of '").append(string2).append("' from '").append(string).append("', not a valid query parameter name").toString());
                localeQueryParam = null;
                continue;
            }
            if (LOCALE_COOKIE.equals(name)) {
                localeCookie = (String)configProp.getValues().get(0);
                if (localeCookie == null || localeCookie.length() == 0 || this.validateCookieName(localeCookie)) continue;
                string2 = localeCookie;
                string = String.valueOf(LOCALE_COOKIE);
                logger.log(TreeLogger.WARN, new StringBuilder(61 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Ignoring invalid value of '").append(string2).append("' from '").append(string).append("', not a valid cookie name").toString());
                localeCookie = null;
                continue;
            }
            if (LOCALE_USEMETA.equals(name)) {
                localeUseMeta = LocalePropertyProviderGenerator.isTrue((String)configProp.getValues().get(0));
                continue;
            }
            if (LOCALE_USERAGENT.equals(name)) {
                localeUserAgent = LocalePropertyProviderGenerator.isTrue((String)configProp.getValues().get(0));
                continue;
            }
            if (!LOCALE_SEARCHORDER.equals(name)) continue;
            localeSearchOrder = (String)configProp.getValues().get(0);
        }
        if ((localeSearchOrder = localeSearchOrder.trim()) == null || localeSearchOrder.length() == 0) {
            localeSearchOrder = "queryparam,cookie,meta,useragent";
        }
        if (fallback == null) {
            fallback = "default";
        }
        StringSourceWriter body = new StringSourceWriter();
        body.println("{");
        body.indent();
        body.println("var locale = null;");
        String[] stringArray = fallback;
        body.println(new StringBuilder(18 + String.valueOf(stringArray).length()).append("var rtlocale = '").append((String)stringArray).append("';").toString());
        body.println("try {");
        for (String method : localeSearchOrder.split(",")) {
            if ("queryparam".equals(method)) {
                if (localeQueryParam == null || localeQueryParam.length() <= 0) continue;
                body.println("if (!locale) {");
                body.indent();
                this.generateQueryParamLookup(logger, (SourceWriter)body, localeQueryParam);
                body.outdent();
                body.println("}");
                continue;
            }
            if ("cookie".equals(method)) {
                if (localeCookie == null || localeCookie.length() <= 0) continue;
                body.println("if (!locale) {");
                body.indent();
                this.generateCookieLookup(logger, (SourceWriter)body, localeCookie);
                body.outdent();
                body.println("}");
                continue;
            }
            if ("meta".equals(method)) {
                if (!localeUseMeta) continue;
                body.println("if (!locale) {");
                body.indent();
                this.generateMetaLookup(logger, (SourceWriter)body);
                body.outdent();
                body.println("}");
                continue;
            }
            if ("useragent".equals(method)) {
                if (!localeUserAgent) continue;
                body.println("if (!locale) {");
                body.indent();
                this.generateUserAgentLookup(logger, (SourceWriter)body);
                body.outdent();
                body.println("}");
                continue;
            }
            logger.log(TreeLogger.WARN, new StringBuilder(40 + String.valueOf(method).length()).append("Ignoring unknown locale lookup method \"").append(method).append("\"").toString());
            body.println(new StringBuilder(36 + String.valueOf(method).length()).append("// ignoring invalid lookup method '").append(method).append("'").toString());
        }
        body.println("if (!locale) {");
        body.indent();
        body.println("locale = $wnd['__gwt_Locale'];");
        body.outdent();
        body.println("}");
        body.println("if (locale) {");
        body.indent();
        body.println("rtlocale = locale;");
        body.outdent();
        body.println("}");
        this.generateInheritanceLookup(logger, (SourceWriter)body);
        body.outdent();
        body.println("} catch (e) {");
        body.indent();
        body.println("alert(\"Unexpected exception in locale detection, using default: \" + e);\n");
        body.outdent();
        body.println("}");
        body.println("$wnd['__gwt_Locale'] = rtlocale;");
        stringArray = fallback;
        body.println(new StringBuilder(20 + String.valueOf(stringArray).length()).append("return locale || \"").append((String)stringArray).append("\";").toString());
        body.outdent();
        body.println("}");
        return body.toString();
    }

    protected void generateCookieLookup(TreeLogger logger, SourceWriter body, String cookieName) throws UnableToCompleteException {
        body.println("var cookies = $doc.cookie;");
        body.println(new StringBuilder(31 + String.valueOf(cookieName).length()).append("var idx = cookies.indexOf(\"").append(cookieName).append("=\");").toString());
        body.println("if (idx >= 0) {");
        body.indent();
        body.println("var end = cookies.indexOf(';', idx);");
        body.println("if (end < 0) {");
        body.indent();
        body.println("end = cookies.length;");
        body.outdent();
        body.println("}");
        int n = cookieName.length() + 1;
        body.println(new StringBuilder(51).append("locale = cookies.substring(idx + ").append(n).append(", end);").toString());
        body.outdent();
        body.println("}");
    }

    protected void generateInheritanceLookup(TreeLogger logger, SourceWriter body) throws UnableToCompleteException {
        body.println("while (locale && !__gwt_isKnownPropertyValue(\"locale\", locale)) {");
        body.indent();
        body.println("var lastIndex = locale.lastIndexOf(\"_\");");
        body.println("if (lastIndex < 0) {");
        body.indent();
        body.println("locale = null;");
        body.println("break;");
        body.outdent();
        body.println("}");
        body.println("locale = locale.substring(0, lastIndex);");
        body.outdent();
        body.println("}");
    }

    protected void generateMetaLookup(TreeLogger logger, SourceWriter body) throws UnableToCompleteException {
        body.println("locale = __gwt_getMetaProperty(\"locale\");");
    }

    protected void generateQueryParamLookup(TreeLogger logger, SourceWriter body, String queryParam) throws UnableToCompleteException {
        body.println("var queryParam = location.search;");
        body.println(new StringBuilder(38 + String.valueOf(queryParam).length()).append("var qpStart = queryParam.indexOf(\"").append(queryParam).append("=\");").toString());
        body.println("if (qpStart >= 0) {");
        body.indent();
        int n = queryParam.length() + 1;
        body.println(new StringBuilder(56).append("var value = queryParam.substring(qpStart + ").append(n).append(");").toString());
        body.println("var end = queryParam.indexOf(\"&\", qpStart);");
        body.println("if (end < 0) {");
        body.indent();
        body.println("end = queryParam.length;");
        body.outdent();
        body.println("}");
        n = queryParam.length() + 1;
        body.println(new StringBuilder(58).append("locale = queryParam.substring(qpStart + ").append(n).append(", end);").toString());
        body.outdent();
        body.println("}");
    }

    protected void generateUserAgentLookup(TreeLogger logger, SourceWriter body) throws UnableToCompleteException {
        body.println("var language = navigator.browserLanguage ? navigator.browserLanguage : navigator.language;");
        body.println("if (language) {");
        body.indent();
        body.println("var parts = language.split(/[-_]/);");
        body.println("if (parts.length > 1) {");
        body.indent();
        body.println("parts[1] = parts[1].toUpperCase();");
        body.outdent();
        body.println("}");
        body.println("locale = parts.join(\"_\");");
        body.outdent();
        body.println("}");
    }

    protected boolean validateCookieName(String cookieName) {
        return COOKIE_PATTERN.matcher(cookieName).matches();
    }

    protected boolean validateQueryParam(String queryParam) {
        return QUERYPARAM_PATTERN.matcher(queryParam).matches();
    }
}

