/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.i18n.client.DateTimeFormatInfo;
import com.google.gwt.i18n.client.DateTimeFormatInfoAdapter;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import com.google.gwt.i18n.client.impl.cldr.DateTimeFormatInfoImpl_en;
import java.util.HashMap;
import java.util.Map;

public class DateTimeFormat
extends com.google.gwt.i18n.shared.DateTimeFormat {
    private static final Map<String, DateTimeFormat> cache = new HashMap<String, DateTimeFormat>();

    public static DateTimeFormat getFormat(PredefinedFormat predef) {
        String pattern;
        if (DateTimeFormat.usesFixedEnglishStrings(predef)) {
            String pattern2;
            switch (predef) {
                case RFC_2822: {
                    pattern2 = "EEE, d MMM yyyy HH:mm:ss Z";
                    break;
                }
                case ISO_8601: {
                    pattern2 = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
                    break;
                }
                default: {
                    String string = String.valueOf((Object)predef);
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string).length()).append("Unexpected predef type ").append(string).toString());
                }
            }
            return DateTimeFormat.getFormat(pattern2, new DateTimeFormatInfoImpl_en());
        }
        DateTimeFormatInfo dtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        switch (predef) {
            case DATE_FULL: {
                pattern = dtfi.dateFormatFull();
                break;
            }
            case DATE_LONG: {
                pattern = dtfi.dateFormatLong();
                break;
            }
            case DATE_MEDIUM: {
                pattern = dtfi.dateFormatMedium();
                break;
            }
            case DATE_SHORT: {
                pattern = dtfi.dateFormatShort();
                break;
            }
            case DATE_TIME_FULL: {
                pattern = dtfi.dateTimeFull(dtfi.timeFormatFull(), dtfi.dateFormatFull());
                break;
            }
            case DATE_TIME_LONG: {
                pattern = dtfi.dateTimeLong(dtfi.timeFormatLong(), dtfi.dateFormatLong());
                break;
            }
            case DATE_TIME_MEDIUM: {
                pattern = dtfi.dateTimeMedium(dtfi.timeFormatMedium(), dtfi.dateFormatMedium());
                break;
            }
            case DATE_TIME_SHORT: {
                pattern = dtfi.dateTimeShort(dtfi.timeFormatShort(), dtfi.dateFormatShort());
                break;
            }
            case DAY: {
                pattern = dtfi.formatDay();
                break;
            }
            case HOUR24_MINUTE: {
                pattern = dtfi.formatHour24Minute();
                break;
            }
            case HOUR24_MINUTE_SECOND: {
                pattern = dtfi.formatHour24MinuteSecond();
                break;
            }
            case HOUR_MINUTE: {
                pattern = dtfi.formatHour12Minute();
                break;
            }
            case HOUR_MINUTE_SECOND: {
                pattern = dtfi.formatHour12MinuteSecond();
                break;
            }
            case MINUTE_SECOND: {
                pattern = dtfi.formatMinuteSecond();
                break;
            }
            case MONTH: {
                pattern = dtfi.formatMonthFull();
                break;
            }
            case MONTH_ABBR: {
                pattern = dtfi.formatMonthAbbrev();
                break;
            }
            case MONTH_ABBR_DAY: {
                pattern = dtfi.formatMonthAbbrevDay();
                break;
            }
            case MONTH_DAY: {
                pattern = dtfi.formatMonthFullDay();
                break;
            }
            case MONTH_NUM_DAY: {
                pattern = dtfi.formatMonthNumDay();
                break;
            }
            case MONTH_WEEKDAY_DAY: {
                pattern = dtfi.formatMonthFullWeekdayDay();
                break;
            }
            case TIME_FULL: {
                pattern = dtfi.timeFormatFull();
                break;
            }
            case TIME_LONG: {
                pattern = dtfi.timeFormatLong();
                break;
            }
            case TIME_MEDIUM: {
                pattern = dtfi.timeFormatMedium();
                break;
            }
            case TIME_SHORT: {
                pattern = dtfi.timeFormatShort();
                break;
            }
            case YEAR: {
                pattern = dtfi.formatYear();
                break;
            }
            case YEAR_MONTH: {
                pattern = dtfi.formatYearMonthFull();
                break;
            }
            case YEAR_MONTH_ABBR: {
                pattern = dtfi.formatYearMonthAbbrev();
                break;
            }
            case YEAR_MONTH_ABBR_DAY: {
                pattern = dtfi.formatYearMonthAbbrevDay();
                break;
            }
            case YEAR_MONTH_DAY: {
                pattern = dtfi.formatYearMonthFullDay();
                break;
            }
            case YEAR_MONTH_NUM: {
                pattern = dtfi.formatYearMonthNum();
                break;
            }
            case YEAR_MONTH_NUM_DAY: {
                pattern = dtfi.formatYearMonthNumDay();
                break;
            }
            case YEAR_MONTH_WEEKDAY_DAY: {
                pattern = dtfi.formatYearMonthWeekdayDay();
                break;
            }
            case YEAR_QUARTER: {
                pattern = dtfi.formatYearQuarterFull();
                break;
            }
            case YEAR_QUARTER_ABBR: {
                pattern = dtfi.formatYearQuarterShort();
                break;
            }
            default: {
                String string = String.valueOf((Object)predef);
                throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Unexpected predefined format ").append(string).toString());
            }
        }
        return DateTimeFormat.getFormat(pattern, dtfi);
    }

    public static DateTimeFormat getFormat(String pattern) {
        return DateTimeFormat.getFormat(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    public static DateTimeFormat getFullDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getLongDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getShortDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_SHORT);
    }

    protected static DateTimeFormat getFormat(String pattern, DateTimeFormatInfo dtfi) {
        DateTimeFormatInfo defaultDtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        DateTimeFormat dtf = null;
        if (dtfi == defaultDtfi) {
            dtf = cache.get(pattern);
        }
        if (dtf == null) {
            dtf = new DateTimeFormat(pattern, dtfi);
            if (dtfi == defaultDtfi) {
                cache.put(pattern, dtf);
            }
        }
        return dtf;
    }

    private static DateTimeFormatInfo getDefaultDateTimeFormatInfo() {
        return LocaleInfo.getCurrentLocale().getDateTimeFormatInfo();
    }

    private static boolean usesFixedEnglishStrings(PredefinedFormat predef) {
        switch (predef) {
            case RFC_2822: {
                return true;
            }
            case ISO_8601: {
                return true;
            }
        }
        return false;
    }

    protected DateTimeFormat(String pattern) {
        this(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    protected DateTimeFormat(String pattern, DateTimeConstants dateTimeConstants) {
        this(pattern, new DateTimeFormatInfoAdapter(dateTimeConstants));
    }

    protected DateTimeFormat(String pattern, DateTimeFormatInfo dtfi) {
        super(pattern, dtfi);
    }

    public static enum PredefinedFormat {
        ISO_8601,
        RFC_2822,
        DATE_FULL,
        DATE_LONG,
        DATE_MEDIUM,
        DATE_SHORT,
        TIME_FULL,
        TIME_LONG,
        TIME_MEDIUM,
        TIME_SHORT,
        DATE_TIME_FULL,
        DATE_TIME_LONG,
        DATE_TIME_MEDIUM,
        DATE_TIME_SHORT,
        DAY,
        HOUR_MINUTE,
        HOUR_MINUTE_SECOND,
        HOUR24_MINUTE,
        HOUR24_MINUTE_SECOND,
        MINUTE_SECOND,
        MONTH,
        MONTH_ABBR,
        MONTH_ABBR_DAY,
        MONTH_DAY,
        MONTH_NUM_DAY,
        MONTH_WEEKDAY_DAY,
        YEAR,
        YEAR_MONTH,
        YEAR_MONTH_ABBR,
        YEAR_MONTH_ABBR_DAY,
        YEAR_MONTH_DAY,
        YEAR_MONTH_NUM,
        YEAR_MONTH_NUM_DAY,
        YEAR_MONTH_WEEKDAY_DAY,
        YEAR_QUARTER,
        YEAR_QUARTER_ABBR;

    }
}

