/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.builder.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.builder.shared.ElementBuilderBase;
import com.google.gwt.dom.builder.shared.StylesBuilder;
import com.google.gwt.dom.client.Element;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeHtml;

public abstract class ElementBuilderImpl {
    private static RegExp HTML_TAG_REGEX;
    private boolean asElementCalled;
    private boolean isEmpty = true;
    private boolean isHtmlOrTextAdded;
    private boolean isStartTagOpen;
    private boolean isStyleClosed;
    private boolean isStyleOpen;
    private final FastPeekStack stack = new FastPeekStack();

    public ElementBuilderImpl() {
        if (HTML_TAG_REGEX == null) {
            HTML_TAG_REGEX = RegExp.compile("^[a-z][a-z0-9]*$", "i");
        }
    }

    public void end() {
        this.endImpl(this.getCurrentTagName());
    }

    public void end(String tagName) {
        String topItem = this.getCurrentTagName();
        if (!topItem.equalsIgnoreCase(tagName)) {
            throw new IllegalStateException(new StringBuilder(54 + String.valueOf(tagName).length() + String.valueOf(topItem).length()).append("Specified tag \"").append(tagName).append("\" does not match the current element \"").append(topItem).append("\"").toString());
        }
        this.endImpl(topItem);
    }

    public void endStyle() {
        if (!this.isStyleOpen) {
            throw new IllegalStateException("Attempting to close a style attribute, but the style attribute isn't open");
        }
        this.maybeCloseStyleAttribute();
    }

    public Element finish() {
        if (!GWT.isClient()) {
            throw new RuntimeException("asElement() can only be called from GWT client code.");
        }
        if (this.asElementCalled) {
            throw new IllegalStateException("asElement() can only be called once.");
        }
        this.asElementCalled = true;
        this.endAllTags();
        return this.doFinishImpl();
    }

    public int getDepth() {
        return this.stack.size();
    }

    public void html(SafeHtml html) {
        this.assertStartTagOpen("html cannot be set on an element that already contains other content or elements.");
        this.lockCurrentElement();
        this.doHtmlImpl(html);
    }

    public void onStart(String tagName, ElementBuilderBase<?> builder) {
        if (this.isEmpty) {
            this.isEmpty = false;
        } else {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("You can only build one top level element.");
            }
            this.assertEndTagNotForbidden("child elements");
            if (!this.getCurrentBuilder().isChildElementSupported()) {
                throw new UnsupportedOperationException(String.valueOf(this.getCurrentTagName()).concat(" does not support child elements."));
            }
        }
        if (this.isHtmlOrTextAdded) {
            throw new IllegalStateException("Cannot append an element after setting text of html.");
        }
        this.assertValidTagName(tagName);
        this.maybeCloseStartTag();
        this.stack.push(builder, tagName);
        this.isStartTagOpen = true;
        this.isStyleOpen = false;
        this.isStyleClosed = false;
        this.isHtmlOrTextAdded = false;
    }

    public abstract StylesBuilder style();

    public void text(String text) {
        this.assertStartTagOpen("text cannot be set on an element that already contains other content or elements.");
        this.lockCurrentElement();
        this.doTextImpl(text);
    }

    protected void assertCanAddAttributeImpl() {
        this.assertStartTagOpen("Attributes cannot be added after appending HTML or adding a child element.");
        this.maybeCloseStyleAttribute();
    }

    protected void assertCanAddStylePropertyImpl() {
        this.assertStartTagOpen("Style properties cannot be added after appending HTML or adding a child element.");
        if (this.isStyleClosed) {
            throw new IllegalStateException("Style properties must be added at the same time. If you already added style properties, you cannot add more after adding non-style attributes.");
        }
        if (!this.isStyleOpen) {
            this.isStyleOpen = true;
            this.doOpenStyleImpl();
        }
    }

    protected void assertValidTagName(String tagName) {
        if (!HTML_TAG_REGEX.test(tagName)) {
            String string = String.valueOf(tagName);
            throw new IllegalArgumentException(string.length() != 0 ? "The specified tag name is invalid: ".concat(string) : new String("The specified tag name is invalid: "));
        }
    }

    protected abstract void doCloseStartTagImpl();

    protected abstract void doCloseStyleAttributeImpl();

    protected abstract void doEndStartTagImpl();

    protected abstract void doEndTagImpl(String var1);

    protected abstract Element doFinishImpl();

    protected abstract void doHtmlImpl(SafeHtml var1);

    protected abstract void doOpenStyleImpl();

    protected abstract void doTextImpl(String var1);

    protected void endAllTags() {
        while (!this.stack.isEmpty()) {
            this.end();
        }
    }

    protected void lockCurrentElement() {
        this.maybeCloseStartTag();
        this.assertEndTagNotForbidden("html");
        this.isHtmlOrTextAdded = true;
    }

    private void assertEndTagNotForbidden(String operation) {
        if (this.getCurrentBuilder().isEndTagForbidden()) {
            String string = this.getCurrentTagName();
            throw new UnsupportedOperationException(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(operation).length()).append(string).append(" does not support ").append(operation).toString());
        }
    }

    private void assertStartTagOpen(String message) {
        if (!this.isStartTagOpen) {
            throw new IllegalStateException(message);
        }
    }

    private void endImpl(String tagName) {
        this.maybeCloseStartTag();
        if (this.getCurrentBuilder().isEndTagForbidden()) {
            this.doEndStartTagImpl();
        } else {
            this.doEndTagImpl(tagName);
        }
        this.isStartTagOpen = false;
        this.isStyleClosed = true;
        this.stack.pop();
        this.isHtmlOrTextAdded = false;
    }

    private ElementBuilderBase<?> getCurrentBuilder() {
        return this.stack.peek().builder;
    }

    private String getCurrentTagName() {
        return this.stack.peek().tagName;
    }

    private void maybeCloseStartTag() {
        this.maybeCloseStyleAttribute();
        if (this.isStartTagOpen) {
            this.isStartTagOpen = false;
            if (!this.getCurrentBuilder().isEndTagForbidden()) {
                this.doCloseStartTagImpl();
            }
        }
    }

    private void maybeCloseStyleAttribute() {
        if (this.isStyleOpen) {
            this.isStyleOpen = false;
            this.isStyleClosed = true;
            this.doCloseStyleAttributeImpl();
        }
    }

    private class FastPeekStack {
        private static final String EMPTY_STACK_MESSAGE = "There are no elements on the stack.";
        private StackNode top;
        private int size = 0;

        private FastPeekStack() {
        }

        public boolean isEmpty() {
            return this.top == null;
        }

        public StackNode peek() {
            this.assertNotEmpty();
            return this.top;
        }

        public StackNode pop() {
            this.assertNotEmpty();
            StackNode toRet = this.top;
            this.top = this.top.next;
            --this.size;
            return toRet;
        }

        public void push(ElementBuilderBase<?> builder, String tagName) {
            StackNode node = new StackNode(tagName, builder);
            node.next = this.top;
            this.top = node;
            ++this.size;
        }

        public int size() {
            return this.size;
        }

        private void assertNotEmpty() {
            if (this.isEmpty()) {
                throw new IllegalStateException(EMPTY_STACK_MESSAGE);
            }
        }
    }

    private static class StackNode {
        private final ElementBuilderBase<?> builder;
        private StackNode next;
        private final String tagName;

        public StackNode(String tagName, ElementBuilderBase<?> builder) {
            this.builder = builder;
            this.tagName = tagName;
        }
    }
}

