/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;

public final class JavaScriptException
extends RuntimeException {
    private static final Object NOT_SET = new Object();
    private String description = "";
    private final Object e;
    private String message;
    private String name;

    private static String getExceptionDescription(Object e) {
        if (e instanceof JavaScriptObject) {
            return JavaScriptException.getExceptionDescription0((JavaScriptObject)e);
        }
        String string = String.valueOf(e);
        return new StringBuilder(0 + String.valueOf(string).length()).append(string).toString();
    }

    private static native String getExceptionDescription0(JavaScriptObject var0);

    private static String getExceptionName(Object e) {
        if (e == null) {
            return "null";
        }
        if (e instanceof JavaScriptObject) {
            return JavaScriptException.getExceptionName0((JavaScriptObject)e);
        }
        if (e instanceof String) {
            return "String";
        }
        return e.getClass().getName();
    }

    private static native String getExceptionName0(JavaScriptObject var0);

    public JavaScriptException(Object e) {
        this(e, "");
    }

    public JavaScriptException(Object e, String description) {
        super(null, null, true, !GWT.isScript());
        this.e = e;
        this.description = description;
    }

    public JavaScriptException(String name, String description) {
        this.message = new StringBuilder(23 + String.valueOf(name).length() + String.valueOf(description).length()).append("JavaScript ").append(name).append(" exception: ").append(description).toString();
        this.name = name;
        this.description = description;
        this.e = NOT_SET;
    }

    protected JavaScriptException(String message) {
        super(message);
        this.message = this.description = message;
        this.e = NOT_SET;
    }

    public boolean isThrownSet() {
        return this.e != NOT_SET;
    }

    public Object getThrown() {
        return this.e == NOT_SET ? null : this.e;
    }

    public String getDescription() {
        this.ensureInit();
        return this.description;
    }

    @Deprecated
    public JavaScriptObject getException() {
        return this.e instanceof JavaScriptObject ? (JavaScriptObject)this.e : null;
    }

    @Override
    public String getMessage() {
        this.ensureInit();
        return this.message;
    }

    public String getName() {
        this.ensureInit();
        return this.name;
    }

    private void ensureInit() {
        if (this.message == null) {
            Object exception = this.getThrown();
            this.name = JavaScriptException.getExceptionName(exception);
            String string = this.description;
            String string2 = JavaScriptException.getExceptionDescription(exception);
            this.description = new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
            string = this.name;
            string2 = this.description;
            this.message = new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append("(").append(string).append(") ").append(string2).toString();
        }
    }
}

