/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Join;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return AlwaysTruePredicate.INSTANCE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return AlwaysFalsePredicate.INSTANCE;
    }

    public static <T> Predicate<T> isNull() {
        return IsNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> notNull() {
        return NotNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(components);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return Predicates.and(Arrays.asList(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return Predicates.and(Arrays.asList(first, second));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(components);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return Predicates.or(Arrays.asList(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return Predicates.or(Arrays.asList(first, second));
    }

    public static <T> Predicate<T> isEqualTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    public static Predicate<Object> isSameAs(@Nullable Object target) {
        return target == null ? Predicates.isNull() : new IsSameAsPredicate(target);
    }

    public static <T> Predicate<T> in(Collection<?> target) {
        return new InPredicate(target);
    }

    public static <A, B> Predicate<A> compose(Predicate<? super B> predicate, Function<? super A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    private static boolean iterableElementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator1.next().equals(iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<? super B> p;
        final Function<? super A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        private CompositionPredicate(Predicate<? super B> p, Function<? super A, ? extends B> f) {
            this.p = Preconditions.checkNotNull(p);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public boolean apply(A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CompositionPredicate) {
                CompositionPredicate that = (CompositionPredicate)obj;
                return ((Object)this.f).equals(that.f) && ((Object)this.p).equals(that.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return this.p.toString() + "(" + this.f.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;
        private static final long serialVersionUID = 0L;

        private InPredicate(Collection<?> target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InPredicate) {
                InPredicate that = (InPredicate)obj;
                return ((Object)this.target).equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.target).hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotNullPredicate implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public boolean apply(Object o) {
            return o != null;
        }

        public String toString() {
            return "NotNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IsNullPredicate implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public boolean apply(Object o) {
            return o == null;
        }

        public String toString() {
            return "IsNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsSameAsPredicate
    implements Predicate<Object>,
    Serializable {
        private final Object target;
        private static final long serialVersionUID = 0L;

        private IsSameAsPredicate(Object target) {
            this.target = target;
        }

        @Override
        public boolean apply(Object o) {
            return this.target == o;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsSameAsPredicate) {
                IsSameAsPredicate that = (IsSameAsPredicate)obj;
                return this.target == that.target;
            }
            return false;
        }

        public String toString() {
            return "IsSameAs(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;
        private static final long serialVersionUID = 0L;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private OrPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = Preconditions.checkContentsNotNull(components);
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int result = 0;
            for (Predicate<T> predicate : this.components) {
                result |= predicate.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OrPredicate) {
                OrPredicate that = (OrPredicate)obj;
                return Predicates.iterableElementsEqual(this.components, that.components);
            }
            return false;
        }

        public String toString() {
            return "Or(" + Join.join(",", this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private AndPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = Preconditions.checkContentsNotNull(components);
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = -1;
            for (Predicate<T> predicate : this.components) {
                result &= predicate.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AndPredicate) {
                AndPredicate that = (AndPredicate)obj;
                return Predicates.iterableElementsEqual(this.components, that.components);
            }
            return false;
        }

        public String toString() {
            return "And(" + Join.join(",", this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Predicate<? super T> predicate;
        private static final long serialVersionUID = 0L;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NotPredicate) {
                NotPredicate that = (NotPredicate)obj;
                return ((Object)this.predicate).equals(that.predicate);
            }
            return false;
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AlwaysFalsePredicate implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public boolean apply(Object o) {
            return false;
        }

        public String toString() {
            return "AlwaysFalse";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AlwaysTruePredicate implements Predicate<Object>
    {
        INSTANCE;


        @Override
        public boolean apply(Object o) {
            return true;
        }

        public String toString() {
            return "AlwaysTrue";
        }
    }
}

