/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.RecoveryFile;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.WriteCtx;
import com.google.cloud.storage.WriteFlushStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SyncAndUploadUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> query;
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final WriteCtx<ResumableWrite> writeCtx;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final RecoveryFile rf;
    private final String uploadId;
    private final BufferHandle copyBuffer;
    private final RequestStream stream;
    private boolean open;
    private @Nullable GatheringByteChannel sync;
    private boolean first;
    private boolean finished;

    SyncAndUploadUnbufferedWritableByteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> query, SettableApiFuture<WriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, WriteCtx<ResumableWrite> writeCtx, RecoveryFile rf, BufferHandle copyBuffer) {
        this.write = write.withDefaultCallContext((ApiCallContext)WriteFlushStrategy.contextWithBucketName(writeCtx.getRequestFactory().bucketName(), GrpcCallContext.createDefault()));
        this.query = query;
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = writeCtx;
        this.deps = deps;
        this.alg = new Alg(alg, resultFuture);
        this.rf = rf;
        this.uploadId = writeCtx.newRequestBuilder().getUploadId();
        this.copyBuffer = copyBuffer;
        this.stream = new RequestStream(this.write, resultFuture);
        this.open = true;
        this.first = true;
        this.finished = false;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ByteBuffer[] duplicates = (ByteBuffer[])Arrays.stream(srcs, offset, offset + length).map(ByteBuffer::duplicate).toArray(ByteBuffer[]::new);
        long prevWritten = this.writeCtx.getTotalSentBytes().get();
        long syncWritten = this.openSync().write(duplicates);
        long goalSize = Math.addExact(prevWritten, syncWritten);
        ChunkSegmenter.ChunkSegment[] segments = this.chunkSegmenter.segmentBuffers(srcs, offset, length);
        this.doUpload(false, segments, goalSize);
        return syncWritten;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            this.doUpload(true, new ChunkSegmenter.ChunkSegment[0], this.writeCtx.getTotalSentBytes().get());
            this.rf.close();
        }
        finally {
            this.open = false;
        }
    }

    private GatheringByteChannel openSync() throws IOException {
        if (this.sync == null) {
            this.sync = this.rf.syncingChannel();
        }
        return this.sync;
    }

    private WriteObjectRequest processSegment(ChunkSegmenter.ChunkSegment segment) {
        WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder();
        if (!this.first) {
            builder.clearUploadId().clearWriteObjectSpec().clearObjectChecksums();
        } else {
            this.first = false;
        }
        Crc32cValue.Crc32cLengthKnown crc32c = segment.getCrc32c();
        ByteString b = segment.getB();
        int contentSize = b.size();
        this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
        long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
        ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
        if (crc32c != null) {
            checksummedData.setCrc32C(crc32c.getValue());
        }
        builder.setWriteOffset(offset).setChecksummedData(checksummedData.build());
        if (!segment.isOnlyFullBlocks()) {
            this.finishMessage(builder);
            this.finished = true;
        }
        WriteObjectRequest build = builder.build();
        return build;
    }

    private @NonNull WriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setWriteOffset(offset);
        WriteObjectRequest message = this.finishMessage(b).build();
        return message;
    }

    private WriteObjectRequest.Builder finishMessage(WriteObjectRequest.Builder b) {
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        b.setFinishWrite(true);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        return b;
    }

    private void doUpload(boolean closing, ChunkSegmenter.ChunkSegment[] segments, long goalSize) {
        AtomicBoolean recover = new AtomicBoolean(false);
        Retrying.run(this.deps, this.alg, () -> {
            long newWritten;
            boolean shouldRecover;
            if (closing && this.sync != null) {
                this.sync.close();
            }
            if (!(shouldRecover = recover.getAndSet(true))) {
                for (ChunkSegmenter.ChunkSegment segment : segments) {
                    WriteObjectRequest writeObjectRequest = this.processSegment(segment);
                    this.stream.onNext(writeObjectRequest);
                }
                if (closing && !this.finished) {
                    WriteObjectRequest message = this.finishMessage();
                    this.stream.onNext(message);
                    this.finished = true;
                }
                if (closing) {
                    this.stream.onCompleted();
                }
            } else {
                if (this.sync != null) {
                    this.sync.close();
                    this.sync = null;
                }
                this.stream.reset();
                QueryWriteStatusRequest req = QueryWriteStatusRequest.newBuilder().setUploadId(this.uploadId).build();
                QueryWriteStatusResponse resp = (QueryWriteStatusResponse)this.query.call((Object)req);
                if (!resp.hasResource()) {
                    long persistedSize = resp.getPersistedSize();
                    if (persistedSize != goalSize) {
                        this.finished = false;
                        this.first = true;
                        this.writeCtx.getTotalSentBytes().set(persistedSize);
                        this.writeCtx.getConfirmedBytes().set(persistedSize);
                        this.writeCtx.getCumulativeCrc32c().set(null);
                        try (SeekableByteChannel reader = this.rf.reader();){
                            reader.position(persistedSize);
                            ByteBuffer buf = (ByteBuffer)this.copyBuffer.get();
                            while (Buffers.fillFrom(buf, reader) != -1) {
                                buf.flip();
                                while (buf.hasRemaining()) {
                                    ChunkSegmenter.ChunkSegment[] recoverySegments;
                                    for (ChunkSegmenter.ChunkSegment segment : recoverySegments = this.chunkSegmenter.segmentBuffer(buf)) {
                                        WriteObjectRequest writeObjectRequest = this.processSegment(segment);
                                        this.stream.onNext(writeObjectRequest);
                                    }
                                }
                                buf.clear();
                            }
                        }
                        if (closing && !this.finished) {
                            WriteObjectRequest message = this.finishMessage();
                            this.stream.onNext(message);
                            this.finished = true;
                        }
                        recover.compareAndSet(true, false);
                        if (closing || this.finished) {
                            this.stream.onCompleted();
                        }
                    }
                } else {
                    com.google.storage.v2.Object resource = resp.getResource();
                    this.resultFuture.set((Object)WriteObjectResponse.newBuilder().setResource(resource).build());
                }
            }
            Preconditions.checkState(((newWritten = this.writeCtx.getTotalSentBytes().get()) == goalSize ? 1 : 0) != 0, (String)"%s == %s", (long)newWritten, (long)goalSize);
            return null;
        }, Conversions.Decoder.identity());
    }

    @VisibleForTesting
    static final class Alg
    implements ResultRetryAlgorithm<WriteObjectResponse> {
        private final ResultRetryAlgorithm<WriteObjectResponse> delegate;
        private final SettableApiFuture<WriteObjectResponse> resultFuture;

        @VisibleForTesting
        Alg(ResultRetryAlgorithm<?> delegate, SettableApiFuture<WriteObjectResponse> resultFuture) {
            this.delegate = delegate;
            this.resultFuture = resultFuture;
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, WriteObjectResponse prevResponse, TimedAttemptSettings prevSettings) {
            return this.delegate.createNextAttempt(prevThrowable, (Object)prevResponse, prevSettings);
        }

        public boolean shouldRetry(Throwable prevThrowable, WriteObjectResponse prevResponse) throws CancellationException {
            boolean shouldRetry = this.delegate.shouldRetry(prevThrowable, (Object)prevResponse);
            if (!shouldRetry && prevThrowable != null) {
                this.resultFuture.setException(prevThrowable);
            }
            return shouldRetry;
        }
    }

    @VisibleForTesting
    static final class RequestStream
    implements ApiStreamObserver<WriteObjectRequest> {
        private static final ApiException CLIENT_RESET_ERROR = ApiExceptionFactory.createException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), (boolean)false);
        private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
        private final SettableApiFuture<WriteObjectResponse> resultFuture;
        private volatile StreamPair streamPair;

        private RequestStream(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, SettableApiFuture<WriteObjectResponse> resultFuture) {
            this.write = write;
            this.resultFuture = resultFuture;
        }

        public void onNext(WriteObjectRequest value) {
            StreamPair pair = this.ensureOpen();
            Throwable err = pair.getResponseStream().error;
            if (err != null) {
                this.reset();
                throw StorageException.coalesce(err);
            }
            RequestStream.halfClosedToUnavailable(() -> pair.getRequestStream().onNext((Object)value));
        }

        public void onError(Throwable t) {
            try {
                RequestStream.halfClosedToUnavailable(() -> this.ensureOpen().getRequestStream().onError(t));
            }
            finally {
                this.streamPair = null;
            }
        }

        public void onCompleted() {
            StreamPair pair = this.ensureOpen();
            Throwable err = pair.getResponseStream().error;
            if (err != null) {
                this.reset();
                throw StorageException.coalesce(err);
            }
            RequestStream.halfClosedToUnavailable(() -> pair.getRequestStream().onCompleted());
            pair.getResponseStream().await();
        }

        private StreamPair ensureOpen() {
            if (this.streamPair == null) {
                ResponseStream responseStream = new ResponseStream(this.resultFuture);
                ApiStreamObserver requestStream = this.write.clientStreamingCall((ApiStreamObserver)responseStream);
                this.streamPair = new StreamPair(requestStream, responseStream);
            }
            return this.streamPair;
        }

        private void reset() {
            if (this.streamPair != null && this.streamPair.getRequestStream() != null) {
                this.streamPair.getRequestStream().onError((Throwable)CLIENT_RESET_ERROR);
            }
            this.streamPair = null;
        }

        static void halfClosedToUnavailable(Runnable r) {
            try {
                r.run();
            }
            catch (IllegalStateException ise) {
                String message = ise.getMessage();
                if (message != null && message.contains("half-closed")) {
                    throw ApiExceptionFactory.createException((Throwable)ise, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), (boolean)true);
                }
                throw ise;
            }
        }
    }

    private static final class StreamPair {
        private final ApiStreamObserver<WriteObjectRequest> requestStream;
        private final ResponseStream responseStream;

        private StreamPair(ApiStreamObserver<WriteObjectRequest> requestStream, ResponseStream responseStream) {
            this.requestStream = requestStream;
            this.responseStream = responseStream;
        }

        public ApiStreamObserver<WriteObjectRequest> getRequestStream() {
            return this.requestStream;
        }

        public ResponseStream getResponseStream() {
            return this.responseStream;
        }
    }

    @VisibleForTesting
    static final class ResponseStream
    implements ApiStreamObserver<WriteObjectResponse> {
        private final SettableApiFuture<Void> invocationHandle;
        private final SettableApiFuture<WriteObjectResponse> resultFuture;
        private volatile WriteObjectResponse last;
        private volatile Throwable error;

        @VisibleForTesting
        ResponseStream(SettableApiFuture<WriteObjectResponse> resultFuture) {
            this.resultFuture = resultFuture;
            this.invocationHandle = SettableApiFuture.create();
        }

        public void onNext(WriteObjectResponse value) {
            this.last = value;
            this.error = null;
        }

        public void onError(Throwable t) {
            this.error = t;
            this.invocationHandle.setException(t);
        }

        public void onCompleted() {
            if (this.last != null && this.last.hasResource()) {
                this.resultFuture.set((Object)this.last);
            }
            this.invocationHandle.set(null);
        }

        void await() {
            ApiExceptions.callAndTranslateApiException(this.invocationHandle);
        }
    }
}

