/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.util.concurrent.Executor;

public class BidiBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = -903533790705476197L;
    private final int bufferSize;

    @InternalApi
    BidiBlobWriteSessionConfig(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        return new Factory(0x1000000);
    }

    @BetaApi
    public BidiBlobWriteSessionConfig withBufferSize(int bufferSize) {
        Preconditions.checkArgument((bufferSize >= 262144 ? 1 : 0) != 0, (String)"bufferSize must be >= %d", (int)262144);
        return new BidiBlobWriteSessionConfig(bufferSize);
    }

    @InternalApi
    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private static final Conversions.Decoder<BidiWriteObjectResponse, BlobInfo> WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER = Conversions.grpc().blobInfo().compose(BidiWriteObjectResponse::getResource);
        private final int bufferSize;

        private Factory(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (s instanceof GrpcStorageImpl) {
                return new DecoratedWritableByteChannelSession(new LazySession(new LazyWriteChannel(() -> {
                    GrpcStorageImpl grpc = (GrpcStorageImpl)s;
                    GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                    BidiWriteObjectRequest req = grpc.getBidiWriteObjectRequest(info, opts);
                    ApiFuture<BidiResumableWrite> startResumableWrite = grpc.startResumableWrite(grpcCallContext, req);
                    return ResumableMedia.gapic().write().bidiByteChannel((BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse>)grpc.storageClient.bidiWriteObjectCallable()).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(grpc.getOptions(), grpc.retryAlgorithmManager.idempotent()).buffered(BufferHandle.allocate(this.bufferSize)).setStartAsync(startResumableWrite).build();
                })), WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER);
            }
            throw new IllegalStateException("Unknown Storage implementation: " + s.getClass().getName());
        }
    }

    private static final class LazySession<R>
    implements WritableByteChannelSession<BufferedWritableByteChannelSession.BufferedWritableByteChannel, R> {
        private final LazyWriteChannel<R> lazy;

        private LazySession(LazyWriteChannel<R> lazy) {
            this.lazy = lazy;
        }

        @Override
        public ApiFuture<BufferedWritableByteChannelSession.BufferedWritableByteChannel> openAsync() {
            return this.lazy.getSession().openAsync();
        }

        @Override
        public ApiFuture<R> getResult() {
            return this.lazy.getSession().getResult();
        }
    }

    private static final class DecoratedWritableByteChannelSession<WBC extends WritableByteChannel, T>
    implements WritableByteChannelSession<WBC, BlobInfo> {
        private final WritableByteChannelSession<WBC, T> delegate;
        private final Conversions.Decoder<T, BlobInfo> decoder;

        private DecoratedWritableByteChannelSession(WritableByteChannelSession<WBC, T> delegate, Conversions.Decoder<T, BlobInfo> decoder) {
            this.delegate = delegate;
            this.decoder = decoder;
        }

        @Override
        public WBC open() {
            try {
                return WritableByteChannelSession.super.open();
            }
            catch (Exception e) {
                throw StorageException.coalesce(e);
            }
        }

        @Override
        public ApiFuture<WBC> openAsync() {
            return this.delegate.openAsync();
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return ApiFutures.transform(this.delegate.getResult(), this.decoder::decode, (Executor)MoreExecutors.directExecutor());
        }
    }
}

