/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Transaction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.PrimitiveArrays;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.JoinHelper;
import org.datanucleus.store.appengine.query.ProjectionResultTransformer;
import org.datanucleus.store.appengine.query.QueryData;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingIterable;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingQueryResultIterator;
import org.datanucleus.store.appengine.query.StreamingQueryResult;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreQuery
implements Serializable {
    static final Expression.Operator GROUP_BY_OP = new Expression.Operator("GROUP BY", Integer.MAX_VALUE);
    static final Expression.Operator HAVING_OP = new Expression.Operator("HAVING", Integer.MAX_VALUE);
    static final Expression.Operator JOIN_OP = new Expression.Operator("JOIN", Integer.MAX_VALUE);
    static final Set<Expression.Operator> UNSUPPORTED_OPERATORS = Utils.newHashSet(Expression.OP_ADD, Expression.OP_COM, Expression.OP_CONCAT, Expression.OP_DIV, Expression.OP_IS, Expression.OP_ISNOT, Expression.OP_LIKE, Expression.OP_MOD, Expression.OP_NEG, Expression.OP_MUL, Expression.OP_NOT, Expression.OP_SUB);
    private static final Map<Expression.Operator, Query.FilterOperator> DATANUCLEUS_OP_TO_APPENGINE_OP = DatastoreQuery.buildNewOpMap();
    final AbstractJavaQuery query;
    private transient com.google.appengine.api.datastore.Query latestDatastoreQuery;
    public static NowProvider NOW_PROVIDER = new NowProvider(){

        public Date now() {
            return new Date();
        }
    };

    private static Map<Expression.Operator, Query.FilterOperator> buildNewOpMap() {
        HashMap<Expression.Operator, Query.FilterOperator> map = new HashMap<Expression.Operator, Query.FilterOperator>();
        map.put((Expression.Operator)Expression.OP_EQ, Query.FilterOperator.EQUAL);
        map.put((Expression.Operator)Expression.OP_GT, Query.FilterOperator.GREATER_THAN);
        map.put((Expression.Operator)Expression.OP_GTEQ, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_LT, Query.FilterOperator.LESS_THAN);
        map.put((Expression.Operator)Expression.OP_LTEQ, Query.FilterOperator.LESS_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_NOTEQ, Query.FilterOperator.NOT_EQUAL);
        return map;
    }

    private boolean isBulkDelete() {
        return this.query.getType() == 2;
    }

    public DatastoreQuery(AbstractJavaQuery query) {
        this.query = query;
    }

    public Object performExecute(Localiser localiser, QueryCompilation compilation, long fromInclNo, long toExclNo, Map<String, ?> parameters) {
        Integer queryTimeout;
        if (this.query.getCandidateClass() == null) {
            throw new FatalNucleusUserException("Candidate class could not be found: " + this.query.getSingleStringQuery());
        }
        DatastoreManager storeMgr = this.getStoreManager();
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), clr);
        if (acmd == null) {
            throw new FatalNucleusUserException("No meta data for " + this.query.getCandidateClass().getName() + ".  Perhaps you need to run the enhancer on this class?");
        }
        storeMgr.validateMetaDataForClass(acmd, clr);
        DatastoreTable table = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
        QueryData qd = this.validate(compilation, parameters, acmd, table, clr);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)localiser.msg("021046", (Object)"DATASTORE", (Object)this.query.getSingleStringQuery(), null));
        }
        if (toExclNo == 0L || this.rangeValueIsSet(toExclNo) && this.rangeValueIsSet(fromInclNo) && toExclNo - fromInclNo <= 0L) {
            return Collections.emptyList();
        }
        this.addFilters(qd);
        this.addSorts(qd);
        Map extensions = this.query.getExtensions();
        if (extensions != null && (queryTimeout = (Integer)extensions.get("javax.persistence.query.timeout")) != null && queryTimeout > 0) {
            this.query.setTimeoutMillis(queryTimeout);
        }
        return this.executeQuery(qd, fromInclNo, toExclNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeQuery(QueryData qd, long fromInclNo, long toExclNo) {
        Map extensions;
        this.processInFilters(qd);
        DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
        if (this.query.getTimeoutMillis() > 0) {
            config.deadline((double)(this.query.getTimeoutMillis() / 1000));
        }
        if ((extensions = this.query.getExtensions()) != null && extensions.get("datanucleus.appengine.datastoreReadConsistency") != null) {
            config.readPolicy(new ReadPolicy(ReadPolicy.Consistency.valueOf((String)((String)extensions.get("datanucleus.appengine.datastoreReadConsistency")))));
        }
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        ManagedConnection mconn = this.getStoreManager().getConnection(this.getObjectManager());
        try {
            if (qd.batchGetKeys != null && qd.primaryDatastoreQuery.getFilterPredicates().size() == 1 && qd.primaryDatastoreQuery.getSortPredicates().isEmpty()) {
                Object object = this.fulfillBatchGetQuery(ds, qd, mconn);
                return object;
            }
            if (qd.joinQuery != null) {
                FetchOptions opts = this.buildFetchOptions(fromInclNo, toExclNo);
                JoinHelper joinHelper = new JoinHelper();
                Object object = this.wrapEntityQueryResult(joinHelper.executeJoinQuery(qd, this, ds, opts), qd.resultTransformer, ds, mconn, null);
                return object;
            }
            this.latestDatastoreQuery = qd.primaryDatastoreQuery;
            Transaction txn = null;
            if (extensions == null || !extensions.containsKey("gae.exclude-query-from-txn") || !((Boolean)extensions.get("gae.exclude-query-from-txn")).booleanValue()) {
                txn = qd.primaryDatastoreQuery.getAncestor() != null ? ds.getCurrentTransaction(null) : null;
            }
            PreparedQuery preparedQuery = ds.prepare(txn, qd.primaryDatastoreQuery);
            FetchOptions opts = this.buildFetchOptions(fromInclNo, toExclNo);
            if (qd.resultType == ResultType.COUNT) {
                List<Integer> list = this.fulfillCountQuery(preparedQuery, opts);
                return list;
            }
            if (qd.resultType == ResultType.KEYS_ONLY || this.isBulkDelete()) {
                qd.primaryDatastoreQuery.setKeysOnly();
            }
            Object object = this.fulfillEntityQuery(preparedQuery, opts, qd.resultTransformer, ds, mconn);
            return object;
        }
        finally {
            mconn.release();
        }
    }

    private void processInFilters(QueryData qd) {
        if (qd.inFilters.isEmpty()) {
            return;
        }
        boolean onlyKeyFilters = true;
        HashSet<Object> batchGetKeys = Utils.newHashSet(new Object[0]);
        for (Map.Entry<String, List<Object>> entry : qd.inFilters.entrySet()) {
            if (!entry.getKey().equals("__key__")) {
                onlyKeyFilters = false;
            } else {
                for (Object obj : entry.getValue()) {
                    batchGetKeys.add(this.internalPkToKey(qd.acmd, obj));
                }
            }
            qd.primaryDatastoreQuery.addFilter(entry.getKey(), Query.FilterOperator.IN, entry.getValue());
        }
        if (onlyKeyFilters) {
            if (qd.batchGetKeys == null) {
                qd.batchGetKeys = batchGetKeys;
            } else {
                qd.batchGetKeys.addAll(batchGetKeys);
            }
        }
    }

    private Object fulfillBatchGetQuery(DatastoreService ds, QueryData qd, ManagedConnection mconn) {
        Transaction innerTxn;
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(this.getObjectManager());
        Transaction transaction = innerTxn = txn == null ? null : txn.getInnerTxn();
        if (this.isBulkDelete()) {
            return this.fulfillBatchDeleteQuery(innerTxn, ds, qd);
        }
        Collection<Entity> entities = ds.get(innerTxn, qd.batchGetKeys).values();
        if (qd.resultType == ResultType.COUNT) {
            return Collections.singletonList(entities.size());
        }
        return this.newStreamingQueryResultForEntities(entities, qd.resultTransformer, mconn, null);
    }

    private long fulfillBatchDeleteQuery(Transaction innerTxn, DatastoreService ds, QueryData qd) {
        Set<Object> keysToDelete = qd.batchGetKeys;
        Map extensions = this.query.getExtensions();
        if (extensions != null && extensions.containsKey("gae.slow-but-more-accurate-jpql-delete-query") && ((Boolean)extensions.get("gae.slow-but-more-accurate-jpql-delete-query")).booleanValue()) {
            Map getResult = ds.get(innerTxn, qd.batchGetKeys);
            keysToDelete = getResult.keySet();
        }
        ds.delete(innerTxn, keysToDelete);
        return keysToDelete.size();
    }

    private List<Integer> fulfillCountQuery(PreparedQuery preparedQuery, FetchOptions opts) {
        if (opts != null) {
            throw new UnsupportedOperationException("The datastore does not support using count() in conjunction with offset and/or limit.  You can get the answer to this query by issuing the query without count() and then counting the size of the result set.");
        }
        return Collections.singletonList(preparedQuery.countEntities());
    }

    private Object fulfillEntityQuery(PreparedQuery preparedQuery, FetchOptions opts, Utils.Function<Entity, Object> resultTransformer, DatastoreService ds, ManagedConnection mconn) {
        QueryResultIterable entityIterable;
        Cursor endCursor = null;
        if (opts != null) {
            if (opts.getLimit() != null) {
                QueryResultList entities = preparedQuery.asQueryResultList(opts);
                endCursor = entities.getCursor();
                entityIterable = entities;
            } else {
                entityIterable = preparedQuery.asQueryResultIterable(opts);
            }
        } else {
            entityIterable = preparedQuery.asQueryResultIterable();
        }
        return this.wrapEntityQueryResult((Iterable<Entity>)entityIterable, resultTransformer, ds, mconn, endCursor);
    }

    private Object wrapEntityQueryResult(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, DatastoreService ds, ManagedConnection mconn, Cursor endCursor) {
        if (this.isBulkDelete()) {
            return this.deleteEntityQueryResult(entities, ds);
        }
        return this.newStreamingQueryResultForEntities(entities, resultTransformer, mconn, endCursor);
    }

    private long deleteEntityQueryResult(Iterable<Entity> entities, DatastoreService ds) {
        ArrayList<Object> keysToDelete = Utils.newArrayList(new Object[0]);
        for (Entity e : entities) {
            keysToDelete.add(e.getKey());
        }
        ds.delete(ds.getCurrentTransaction(null), keysToDelete);
        return keysToDelete.size();
    }

    private List<?> newStreamingQueryResultForEntities(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, ManagedConnection mconn, Cursor endCursor) {
        return DatastoreQuery.newStreamingQueryResultForEntities(entities, resultTransformer, mconn, endCursor, this.query);
    }

    public static List<?> newStreamingQueryResultForEntities(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, final ManagedConnection mconn, Cursor endCursor, AbstractJavaQuery query) {
        RuntimeExceptionWrappingIterable iterable = entities instanceof QueryResultIterable ? new RuntimeExceptionWrappingIterable((Iterable)((QueryResultIterable)entities)){

            @Override
            Iterator<Entity> newIterator(Iterator<Entity> innerIter) {
                return new RuntimeExceptionWrappingQueryResultIterator((QueryResultIterator<Entity>)((QueryResultIterator)innerIter));
            }
        } : new RuntimeExceptionWrappingIterable(entities);
        final StreamingQueryResult qr = new StreamingQueryResult((Query)query, iterable, resultTransformer, endCursor);
        ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

            public void managedConnectionPreClose() {
            }

            public void managedConnectionPostClose() {
            }

            public void managedConnectionFlushed() {
                qr.disconnect();
            }

            public void resourcePostClose() {
                mconn.removeListener((ManagedConnectionResourceListener)this);
            }
        };
        mconn.addListener(listener);
        qr.addConnectionListener(listener);
        return qr;
    }

    private boolean rangeValueIsSet(long rangeVal) {
        return rangeVal != Long.MAX_VALUE;
    }

    FetchOptions buildFetchOptions(long fromInclNo, long toExclNo) {
        Cursor cursor;
        FetchOptions opts = null;
        Integer offset = null;
        if (fromInclNo != 0L && this.rangeValueIsSet(fromInclNo)) {
            offset = (int)Math.min(Integer.MAX_VALUE, fromInclNo);
            opts = FetchOptions.Builder.withOffset((int)offset);
        }
        if (this.rangeValueIsSet(toExclNo)) {
            int intExclNo = (int)Math.min(Integer.MAX_VALUE, toExclNo);
            if (opts == null) {
                opts = FetchOptions.Builder.withLimit((int)intExclNo);
            } else {
                opts.limit(intExclNo - offset);
            }
        }
        if ((cursor = this.getCursor()) != null) {
            if (opts == null) {
                opts = FetchOptions.Builder.withCursor((Cursor)cursor);
            } else {
                opts.cursor(cursor);
            }
        }
        return opts;
    }

    private Cursor getCursor() {
        Object obj = this.query.getExtension("gae.query.cursor");
        if (obj != null) {
            if (obj instanceof Cursor) {
                return (Cursor)obj;
            }
            return Cursor.fromWebSafeString((String)((String)obj));
        }
        return null;
    }

    private Object entityToPojo(Entity entity, AbstractClassMetaData acmd, ClassLoaderResolver clr, DatastoreManager storeMgr, FetchPlan fp) {
        return DatastoreQuery.entityToPojo(entity, acmd, clr, this.getObjectManager(), this.query.getIgnoreCache(), fp);
    }

    public static Object entityToPojo(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, ObjectManager om, boolean ignoreCache, final FetchPlan fetchPlan) {
        final DatastoreManager storeMgr = (DatastoreManager)om.getStoreManager();
        storeMgr.validateMetaDataForClass(acmd, clr);
        FieldValues fv = new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity, DatastoreFieldManager.Operation.READ));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity, DatastoreFieldManager.Operation.READ));
            }

            public FetchPlan getFetchPlanForLoading() {
                return fetchPlan;
            }
        };
        Object pojo = om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), fv, ignoreCache, true);
        StateManager stateMgr = om.findStateManager(pojo);
        DatastorePersistenceHandler handler = storeMgr.getPersistenceHandler();
        handler.setAssociatedEntity(stateMgr, EntityUtils.getCurrentTransaction(om), entity);
        int[] fieldsToFetch = fetchPlan != null ? fetchPlan.getFetchPlanForClass(acmd).getFieldsInActualFetchPlan() : acmd.getAllMemberPositions();
        storeMgr.getPersistenceHandler().fetchObject(stateMgr, fieldsToFetch);
        return pojo;
    }

    private static Object entityToPojoPrimaryKey(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, final DatastoreManager storeMgr, ObjectManager om) {
        storeMgr.validateMetaDataForClass(acmd, clr);
        FieldValues fv = new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity, DatastoreFieldManager.Operation.READ));
            }

            public void fetchNonLoadedFields(StateManager sm) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        };
        return om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), fv, false, true);
    }

    private QueryData validate(QueryCompilation compilation, Map<String, ?> parameters, final AbstractClassMetaData acmd, DatastoreTable table, final ClassLoaderResolver clr) {
        if (this.query.getType() == 1) {
            throw new FatalNucleusUserException("Only select and delete statements are supported.");
        }
        if (this.query.getGrouping() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), GROUP_BY_OP);
        }
        if (this.query.getHaving() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), HAVING_OP);
        }
        final ArrayList<Object> projectionFields = Utils.newArrayList(new Object[0]);
        ResultType resultType = this.validateResultExpression(compilation, acmd, projectionFields);
        String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
        Utils.Function<Object, Object> resultTransformer = resultType == ResultType.KEYS_ONLY ? new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return DatastoreQuery.entityToPojoPrimaryKey(from, acmd, clr, DatastoreQuery.this.getDatastoreManager(), DatastoreQuery.this.getObjectManager());
            }
        } : new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                FetchPlan fp = DatastoreQuery.this.query.getFetchPlan();
                if (!projectionFields.isEmpty()) {
                    fp = null;
                }
                return DatastoreQuery.this.entityToPojo(from, acmd, clr, DatastoreQuery.this.getDatastoreManager(), fp);
            }
        };
        if (!projectionFields.isEmpty()) {
            resultTransformer = new ProjectionResultTransformer(resultTransformer, this.getObjectManager(), projectionFields, compilation.getCandidateAlias());
        }
        QueryData qd = new QueryData(parameters, acmd, table, compilation, new com.google.appengine.api.datastore.Query(kind), resultType, resultTransformer);
        if (compilation.getExprFrom() != null) {
            for (Expression fromExpr : compilation.getExprFrom()) {
                this.processFromExpression(qd, fromExpr);
            }
        }
        return qd;
    }

    private ResultType validateResultExpression(QueryCompilation compilation, AbstractClassMetaData acmd, List<String> projectionFields) {
        ResultType resultType = null;
        if (compilation.getExprResult() != null) {
            for (Expression resultExpr : compilation.getExprResult()) {
                if (resultExpr instanceof InvokeExpression) {
                    InvokeExpression invokeExpr = (InvokeExpression)resultExpr;
                    if (!this.isCountOperation(invokeExpr.getOperation())) {
                        Expression.Operator operator = new Expression.Operator(invokeExpr.getOperation(), 0);
                        throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
                    }
                    if (!projectionFields.isEmpty()) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    resultType = ResultType.COUNT;
                    continue;
                }
                if (resultExpr instanceof PrimaryExpression) {
                    PrimaryExpression primaryExpr;
                    if (resultType == ResultType.COUNT) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    if (resultType == null) {
                        resultType = ResultType.KEYS_ONLY;
                    }
                    if ((primaryExpr = (PrimaryExpression)resultExpr).getId().equals(compilation.getCandidateAlias())) continue;
                    AbstractMemberMetaData ammd = this.getMemberMetaData(acmd, this.getTuples(primaryExpr, compilation.getCandidateAlias()));
                    if (ammd == null) {
                        throw this.noMetaDataException(primaryExpr.getId(), acmd.getFullClassName());
                    }
                    projectionFields.add(primaryExpr.getId());
                    if (!(ammd.getParent() instanceof EmbeddedMetaData) && ammd.isPrimaryKey()) continue;
                    resultType = ResultType.ENTITY_PROJECTION;
                    continue;
                }
                Expression.Operator operator = new Expression.Operator(resultExpr.getClass().getName(), 0);
                throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
            }
        }
        if (resultType == null) {
            resultType = ResultType.ENTITY;
        }
        return resultType;
    }

    private boolean isCountOperation(String operation) {
        if (this.getStoreManager().isJPA()) {
            return operation.toLowerCase().equals("count");
        }
        return operation.equals("count") || operation.equals("COUNT");
    }

    private UnsupportedDatastoreFeatureException newAggregateAndRowResultsException() {
        return new UnsupportedDatastoreFeatureException("Cannot combine an aggregate results with row results.");
    }

    private void processFromExpression(QueryData qd, Expression expr) {
        if (expr instanceof JoinExpression) {
            JoinExpression joinExpr = (JoinExpression)expr;
            if (joinExpr.getType() != JoinExpression.JoinType.JOIN_INNER && joinExpr.getType() != JoinExpression.JoinType.JOIN_INNER_FETCH) {
                throw new UnsupportedDatastoreFeatureException("Cannot fulfill outer join queries.");
            }
            qd.joinOrderExpression = this.createJoinOrderExpression(joinExpr.getPrimaryExpression());
        }
        if (expr.getLeft() != null) {
            this.processFromExpression(qd, expr.getLeft());
        }
        if (expr.getRight() != null) {
            this.processFromExpression(qd, expr.getRight());
        }
    }

    private void addSorts(QueryData qd) {
        Expression[] orderBys = qd.compilation.getExprOrdering();
        if (orderBys == null) {
            return;
        }
        for (Expression expr : orderBys) {
            Query.SortDirection dir = DatastoreQuery.getSortDirection((OrderExpression)expr);
            String sortProp = this.getSortProperty(qd, expr);
            qd.primaryDatastoreQuery.addSort(sortProp, dir);
        }
    }

    static Query.SortDirection getSortDirection(OrderExpression oe) {
        return oe.getSortOrder() == null || oe.getSortOrder().equals("ascending") ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING;
    }

    private boolean isJoin(Expression expr, List<String> tuples) {
        return expr instanceof VariableExpression || tuples.size() > 1 && this.getSymbolTable().hasSymbol(tuples.get(0));
    }

    String getSortProperty(QueryData qd, Expression expr) {
        AbstractMemberMetaData ammd;
        OrderExpression oe = (OrderExpression)expr;
        PrimaryExpression left = (PrimaryExpression)oe.getLeft();
        AbstractClassMetaData acmd = qd.acmd;
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        if (this.isJoin(left.getLeft(), tuples)) {
            acmd = this.getJoinClassMetaData(left.getLeft(), tuples, qd);
        }
        if ((ammd = this.getMemberMetaData(acmd, tuples)) == null) {
            throw this.noMetaDataException(left.getId(), acmd.getFullClassName());
        }
        if (this.isParentPK(ammd)) {
            throw new UnsupportedDatastoreFeatureException("Cannot sort by parent.");
        }
        String sortProp = ammd.isPrimaryKey() ? "__key__" : this.determinePropertyName(ammd);
        return sortProp;
    }

    IdentifierFactory getIdentifierFactory() {
        return this.getStoreManager().getIdentifierFactory();
    }

    private DatastoreManager getStoreManager() {
        return (DatastoreManager)this.getObjectManager().getStoreManager();
    }

    private void addFilters(QueryData qd) {
        Expression filter = qd.compilation.getExprFilter();
        this.addExpression(filter, qd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addExpression(Expression expr, QueryData qd) {
        if (expr == null) {
            return;
        }
        this.checkForUnsupportedOperator(expr.getOperator());
        if (qd.isOrExpression) {
            this.checkForUnsupportedOrOperator(expr.getOperator());
        }
        if (expr instanceof DyadicExpression) {
            if (expr.getOperator().equals(Expression.OP_AND)) {
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                return;
            } else if (expr.getOperator().equals(Expression.OP_OR)) {
                boolean reset = !qd.isOrExpression;
                qd.isOrExpression = true;
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                if (!reset) return;
                qd.isOrExpression = false;
                qd.currentOrProperty = null;
                return;
            } else {
                if (DATANUCLEUS_OP_TO_APPENGINE_OP.get(expr.getOperator()) == null) {
                    throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), expr.getOperator());
                }
                if (expr.getLeft() instanceof PrimaryExpression) {
                    this.addLeftPrimaryExpression((PrimaryExpression)expr.getLeft(), expr.getOperator(), expr.getRight(), qd);
                    return;
                } else {
                    this.addExpression(expr.getLeft(), qd);
                    this.addExpression(expr.getRight(), qd);
                }
            }
            return;
        } else if (expr instanceof PrimaryExpression) {
            this.addExpression(expr.getLeft(), qd);
            this.addExpression(expr.getRight(), qd);
            return;
        } else if (expr instanceof InvokeExpression) {
            InvokeExpression invocation = (InvokeExpression)expr;
            if (invocation.getOperation().equals("contains") && invocation.getArguments().size() == 1) {
                this.handleContainsOperation(invocation, expr, qd);
                return;
            } else if (invocation.getOperation().equals("startsWith") && invocation.getArguments().size() == 1) {
                this.handleStartsWithOperation(invocation, expr, qd);
                return;
            } else {
                if (!invocation.getOperation().equals("matches") || invocation.getArguments().size() != 1) throw this.newUnsupportedQueryMethodException(invocation);
                this.handleMatchesOperation(invocation, expr, qd);
            }
            return;
        } else {
            if (!(expr instanceof VariableExpression)) throw new UnsupportedDatastoreFeatureException("Unexpected expression type while parsing query: " + expr.getClass().getName());
            VariableExpression varExpr = (VariableExpression)expr;
            throw new FatalNucleusUserException("Unexpected expression type while parsing query.  Are you certain that a field named " + varExpr.getId() + " exists on your object?");
        }
    }

    private void checkForUnsupportedOrOperator(Expression.Operator operator) {
        if (operator != null && !operator.equals(Expression.OP_EQ) && !operator.equals(Expression.OP_OR)) {
            throw new UnsupportedDatastoreFeatureException("'or' filters can only check equality");
        }
    }

    private void handleMatchesOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        if (expr.getLeft() instanceof PrimaryExpression && param instanceof Literal) {
            String matchesExpr = this.getPrefixFromMatchesExpression(((Literal)param).getLiteral());
            this.addPrefix((PrimaryExpression)expr.getLeft(), (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
        } else if (expr.getLeft() instanceof PrimaryExpression && param instanceof ParameterExpression) {
            ParameterExpression parameterExpression = (ParameterExpression)param;
            Object parameterValue = this.getParameterValue(qd, parameterExpression);
            String matchesExpr = this.getPrefixFromMatchesExpression(parameterValue);
            this.addPrefix((PrimaryExpression)expr.getLeft(), (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private String getPrefixFromMatchesExpression(Object matchesExprObj) {
        if (matchesExprObj instanceof Character) {
            matchesExprObj = matchesExprObj.toString();
        }
        if (!(matchesExprObj instanceof String)) {
            throw new FatalNucleusUserException("Prefix matching only supported on strings (received a " + matchesExprObj.getClass().getName() + ").");
        }
        String matchesExpr = (String)matchesExprObj;
        String wildcardExpr = this.getWildcardExpression();
        int wildcardIndex = matchesExpr.indexOf(wildcardExpr);
        if (wildcardIndex == -1 || wildcardIndex != matchesExpr.length() - wildcardExpr.length()) {
            throw new UnsupportedDatastoreFeatureException("Wildcard must appear at the end of the expression string (only prefix matches are supported)");
        }
        return matchesExpr.substring(0, wildcardIndex);
    }

    private String getWildcardExpression() {
        if (this.getStoreManager().isJPA()) {
            return "%";
        }
        return ".*";
    }

    private void addPrefix(PrimaryExpression left, Expression right, String prefix, QueryData qd) {
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_GTEQ, right, qd);
        Literal param = this.getUpperLimitForStartsWithStr(prefix);
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_LT, (Expression)param, qd);
    }

    private void handleStartsWithOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        param.bind();
        if (expr.getLeft() instanceof PrimaryExpression && param instanceof Literal) {
            this.addPrefix((PrimaryExpression)expr.getLeft(), param, (String)((Literal)param).getLiteral(), qd);
        } else if (expr.getLeft() instanceof PrimaryExpression && param instanceof ParameterExpression) {
            Object parameterValue = this.getParameterValue(qd, (ParameterExpression)param);
            this.addPrefix((PrimaryExpression)expr.getLeft(), param, (String)parameterValue, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private void handleContainsOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        param.bind();
        if (expr.getLeft() instanceof PrimaryExpression) {
            PrimaryExpression left = (PrimaryExpression)expr.getLeft();
            this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_EQ, param, qd);
        } else if (expr.getLeft() instanceof ParameterExpression && param instanceof PrimaryExpression) {
            ParameterExpression pe = (ParameterExpression)expr.getLeft();
            this.addLeftPrimaryExpression((PrimaryExpression)param, (Expression.Operator)Expression.OP_EQ, (Expression)pe, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private Literal getUpperLimitForStartsWithStr(String val) {
        byte[] bytes = val.getBytes();
        int i = bytes.length - 1;
        while (i >= 0) {
            byte[] endKey = new byte[i + 1];
            System.arraycopy(bytes, 0, endKey, 0, i + 1);
            int n = i--;
            endKey[n] = (byte)(endKey[n] + 1);
            if (endKey[n] == 0) continue;
            return new Literal((Object)new String(endKey));
        }
        return null;
    }

    private UnsupportedDatastoreFeatureException newUnsupportedQueryMethodException(InvokeExpression invocation) {
        throw new UnsupportedDatastoreFeatureException("Unsupported method <" + invocation.getOperation() + "> while parsing expression: " + invocation);
    }

    private Object getParameterValue(QueryData qd, ParameterExpression pe) {
        if (pe.getPosition() != -1 && qd.parameters != null && qd.parameters.get(pe.getPosition()) != null) {
            return qd.parameters.get(pe.getPosition());
        }
        Object paramValue = qd.parameters.get(pe.getId());
        if (paramValue == null) {
            try {
                paramValue = qd.parameters.get(Integer.parseInt(pe.getId()));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return paramValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLeftPrimaryExpression(PrimaryExpression left, Expression.Operator operator, Expression right, QueryData qd) {
        void var6_15;
        String datastorePropName;
        void var6_11;
        AbstractMemberMetaData ammd;
        Query.FilterOperator op = DATANUCLEUS_OP_TO_APPENGINE_OP.get(operator);
        if (op == null) {
            throw new UnsupportedDatastoreFeatureException("Operator " + operator + " does not have a " + "corresponding operator in the datastore api.");
        }
        if (right instanceof PrimaryExpression) {
            Object v = qd.parameters.get(((PrimaryExpression)right).getId());
        } else if (right instanceof Literal) {
            Object object = ((Literal)right).getLiteral();
        } else if (right instanceof ParameterExpression) {
            Object object = this.getParameterValue(qd, (ParameterExpression)right);
        } else if (right instanceof DyadicExpression) {
            Object object = this.getValueFromDyadicExpression(right);
        } else if (right instanceof InvokeExpression) {
            InvokeExpression invoke = (InvokeExpression)right;
            if (!invoke.getOperation().equals("CURRENT_TIMESTAMP") && !invoke.getOperation().equals("CURRENT_DATE")) throw this.newUnsupportedQueryMethodException((InvokeExpression)right);
            Date date = NOW_PROVIDER.now();
        } else {
            if (!(right instanceof VariableExpression)) throw new UnsupportedDatastoreFeatureException("Right side of expression is of unexpected type: " + right.getClass().getName());
            if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
                throw new UnsupportedDatastoreFeatureException("Operator " + operator + " cannot be " + "used as part of the join condition.  Use 'contains' if joining on a Collection field " + "and equality if joining on a single-value field.");
            }
            qd.joinVariableExpression = (VariableExpression)right;
            qd.joinOrderExpression = this.createJoinOrderExpression(left);
            return;
        }
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        AbstractClassMetaData acmd = qd.acmd;
        com.google.appengine.api.datastore.Query datastoreQuery = qd.primaryDatastoreQuery;
        if (this.isJoin(left.getLeft(), tuples)) {
            acmd = this.getJoinClassMetaData(left.getLeft(), tuples, qd);
            datastoreQuery = qd.joinQuery;
            if (datastoreQuery == null) {
                String kind = EntityUtils.determineKind(acmd, this.getObjectManager());
                datastoreQuery = new com.google.appengine.api.datastore.Query(kind);
                datastoreQuery.setKeysOnly();
                qd.joinQuery = datastoreQuery;
            }
        }
        if ((ammd = this.getMemberMetaData(acmd, tuples)) == null) {
            throw this.noMetaDataException(left.getId(), acmd.getFullClassName());
        }
        JavaTypeMapping mapping = this.getMappingForFieldWithName(tuples, qd, acmd);
        if (mapping instanceof PersistenceCapableMapping) {
            this.processPersistenceCapableMapping(qd, op, ammd, var6_11);
            return;
        }
        if (this.isParentPK(ammd)) {
            this.addParentFilter(op, this.internalPkToKey(acmd, var6_11), qd.primaryDatastoreQuery);
            return;
        }
        if (ammd.isPrimaryKey()) {
            if (var6_11 instanceof Collection) {
                this.processPotentialBatchGet(qd, (Collection)var6_11, acmd, op);
                ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
                for (Object obj : (Collection)var6_11) {
                    keys.add(this.internalPkToKey(acmd, obj));
                }
                ArrayList<Object> arrayList = keys;
            } else {
                Key key = this.internalPkToKey(acmd, var6_11);
            }
            datastorePropName = "__key__";
        } else {
            datastorePropName = this.determinePropertyName(ammd);
        }
        Object object = this.pojoParamToDatastoreParam(var6_15);
        if (qd.isOrExpression) {
            this.addLeftPrimaryOrExpression(qd, datastorePropName, object);
            return;
        }
        if (object instanceof Collection) {
            if (op != Query.FilterOperator.EQUAL) throw new UnsupportedDatastoreFeatureException("Collection parameters are only supported for equality filters.");
            op = Query.FilterOperator.IN;
        }
        try {
            datastoreQuery.addFilter(datastorePropName, op, object);
            return;
        }
        catch (IllegalArgumentException iae) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(iae);
        }
    }

    private void addLeftPrimaryOrExpression(QueryData qd, String datastorePropName, Object value) {
        if (qd.currentOrProperty == null) {
            qd.currentOrProperty = datastorePropName;
        } else if (!qd.currentOrProperty.equals(datastorePropName)) {
            throw new UnsupportedDatastoreFeatureException("Or filters cannot be applied to multiple properties (found both " + qd.currentOrProperty + " and " + datastorePropName + ").");
        }
        List<Object> valueList = qd.inFilters.get(datastorePropName);
        if (valueList == null) {
            valueList = Utils.newArrayList(new Object[0]);
            qd.inFilters.put(datastorePropName, valueList);
        }
        if (value instanceof Iterable) {
            for (Object v : (Iterable)value) {
                valueList.add(v);
            }
        } else {
            valueList.add(value);
        }
    }

    private AbstractClassMetaData getJoinClassMetaData(Expression expr, List<String> tuples, QueryData qd) {
        if (expr instanceof VariableExpression) {
            if (qd.joinVariableExpression == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Encountered a variable expression that isn't part of a join.  Maybe you're " + "referencing a non-existent field of an embedded class.");
            }
            if (!((VariableExpression)expr).getId().equals(qd.joinVariableExpression.getId())) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Encountered a variable (" + ((VariableExpression)expr).getId() + ") that doesn't match the join variable (" + qd.joinVariableExpression.getId() + ")");
            }
            Class joinedClass = this.getSymbolTable().getSymbol(qd.joinVariableExpression.getId()).getValueType();
            return this.getMetaDataManager().getMetaDataForClass(joinedClass, this.getClassLoaderResolver());
        }
        Symbol sym = this.getSymbolTable().getSymbol(tuples.get(0));
        tuples.remove(0);
        return this.getMetaDataManager().getMetaDataForClass(sym.getValueType(), this.getClassLoaderResolver());
    }

    private OrderExpression createJoinOrderExpression(PrimaryExpression expression) {
        SymbolTable symTable = this.getSymbolTable();
        PrimaryExpression primaryOrderExpr = new PrimaryExpression(symTable, expression.getTuples());
        return new OrderExpression(symTable, (Expression)primaryOrderExpr);
    }

    private SymbolTable getSymbolTable() {
        return this.query.getCompilation().getSymbolTable();
    }

    private void processPotentialBatchGet(QueryData qd, Collection value, AbstractClassMetaData acmd, Query.FilterOperator op) {
        if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
            throw new FatalNucleusUserException("Batch lookup by primary key is only supported with the equality operator.");
        }
        qd.batchGetKeys = Utils.newHashSet(new Object[0]);
        for (Object obj : value) {
            qd.batchGetKeys.add(this.internalPkToKey(acmd, obj));
        }
    }

    private Object getValueFromDyadicExpression(Expression expr) {
        DyadicExpression dyadic = (DyadicExpression)expr;
        if (dyadic.getLeft() instanceof Literal && ((Literal)dyadic.getLeft()).getLiteral() instanceof Number && dyadic.getRight() == null && Expression.OP_NEG.equals(dyadic.getOperator())) {
            Number negateMe = (Number)((Literal)dyadic.getLeft()).getLiteral();
            return this.negateNumber(negateMe);
        }
        throw new UnsupportedDatastoreFeatureException("Right side of expression is composed of unsupported components.  Left: " + dyadic.getLeft().getClass().getName() + ", Op: " + dyadic.getOperator() + ", Right: " + dyadic.getRight());
    }

    private List<String> getTuples(PrimaryExpression expr, String alias) {
        ArrayList<Object> tuples = Utils.newArrayList(new Object[0]);
        tuples.addAll(expr.getTuples());
        return DatastoreQuery.getTuples(tuples, alias);
    }

    static List<String> getTuples(List<String> tuples, String alias) {
        if (alias != null && tuples.size() > 1 && alias.equals(tuples.get(0))) {
            tuples = tuples.subList(1, tuples.size());
        }
        return tuples;
    }

    private Object pojoParamToDatastoreParam(Object param) {
        if (param instanceof Enum) {
            param = ((Enum)param).name();
        } else if (param instanceof byte[]) {
            param = new ShortBlob((byte[])param);
        } else if (param instanceof Byte[]) {
            param = new ShortBlob(PrimitiveArrays.toByteArray(Arrays.asList((Byte[])param)));
        } else if (param instanceof BigDecimal) {
            param = ((BigDecimal)param).doubleValue();
        } else if (param instanceof Character) {
            param = param.toString();
        }
        return param;
    }

    private NucleusException noMetaDataException(String member, String fullClassName) {
        return new FatalNucleusUserException("No meta-data for member named " + member + " on class " + fullClassName + ".  Are you sure you provided the correct member name in your query?");
    }

    private Object negateNumber(Number negateMe) {
        if (negateMe instanceof BigDecimal) {
            return ((BigDecimal)negateMe).negate().doubleValue();
        }
        if (negateMe instanceof Float) {
            return Float.valueOf(-((Float)negateMe).floatValue());
        }
        if (negateMe instanceof Double) {
            return -((Double)negateMe).doubleValue();
        }
        return -negateMe.longValue();
    }

    JavaTypeMapping getMappingForFieldWithName(List<String> tuples, QueryData qd, AbstractClassMetaData acmd) {
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        JavaTypeMapping mapping = null;
        for (String tuple : tuples) {
            DatastoreTable table = qd.tableMap.get(acmd.getFullClassName());
            if (table == null) {
                table = this.getStoreManager().getDatastoreClass(acmd.getFullClassName(), clr);
                qd.tableMap.put(acmd.getFullClassName(), table);
            }
            mapping = table.getMemberMapping(tuple);
            acmd = this.getMetaDataManager().getMetaDataForClass(mapping.getMemberMetaData().getType(), clr);
        }
        return mapping;
    }

    private AbstractMemberMetaData getMemberMetaData(AbstractClassMetaData acmd, List<String> tuples) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(tuples.get(0));
        if (ammd == null || tuples.size() == 1) {
            return ammd;
        }
        String parentFullClassName = acmd.getFullClassName();
        for (String tuple : tuples.subList(1, tuples.size())) {
            EmbeddedMetaData emd = ammd.getEmbeddedMetaData();
            if (emd == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Can only reference properties of a sub-object if " + "the sub-object is embedded.");
            }
            DatastoreTable parentTable = this.getStoreManager().getDatastoreClass(parentFullClassName, this.getClassLoaderResolver());
            parentFullClassName = ammd.getTypeName();
            AbstractMemberMetaData parentField = (AbstractMemberMetaData)emd.getParent();
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)parentTable.getMappingForFullFieldName(parentField.getFullFieldName());
            ammd = this.findMemberMetaDataWithName(tuple, embeddedMapping);
            if (ammd != null) continue;
            break;
        }
        return ammd;
    }

    private AbstractMemberMetaData findMemberMetaDataWithName(String name, EmbeddedMapping embeddedMapping) {
        int numMappings = embeddedMapping.getNumberOfJavaTypeMappings();
        for (int i = 0; i < numMappings; ++i) {
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            if (!fieldMapping.getMemberMetaData().getName().equals(name)) continue;
            return fieldMapping.getMemberMetaData();
        }
        return null;
    }

    private void processPersistenceCapableMapping(QueryData qd, Query.FilterOperator op, AbstractMemberMetaData ammd, Object value) {
        Object jdoPrimaryKey;
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        if (value instanceof Key || value instanceof String) {
            jdoPrimaryKey = value;
        } else if (value instanceof Long || value instanceof Integer) {
            String kind = EntityUtils.determineKind(acmd, this.getObjectManager());
            jdoPrimaryKey = KeyFactory.createKey((String)kind, (long)((Number)value).longValue());
        } else if (value == null) {
            jdoPrimaryKey = null;
        } else {
            ApiAdapter apiAdapter = this.getObjectManager().getApiAdapter();
            jdoPrimaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(value));
            if (jdoPrimaryKey == null) {
                StateManager sm = apiAdapter.newStateManager(this.getObjectManager(), acmd);
                sm.initialiseForHollow(null, null, value.getClass());
                sm.copyFieldsFromObject((PersistenceCapable)value, acmd.getPKMemberPositions());
                jdoPrimaryKey = sm.provideField(acmd.getPKMemberPositions()[0]);
            }
            if (jdoPrimaryKey == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Parameter value " + value + " does not have an id.");
            }
        }
        Key valueKey = null;
        if (jdoPrimaryKey != null) {
            valueKey = this.internalPkToKey(acmd, jdoPrimaryKey);
            this.verifyRelatedKeyIsOfProperType(ammd, valueKey, acmd);
        }
        if (!qd.tableMap.get(ammd.getAbstractClassMetaData().getFullClassName()).isParentKeyProvider(ammd)) {
            if (op != Query.FilterOperator.EQUAL) {
                throw new UnsupportedDatastoreFeatureException("Only the equals operator is supported on conditions involving the owning side of a one-to-one.");
            }
            if (valueKey == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Cannot query for parents with null children.");
            }
            if (valueKey.getParent() == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Key of parameter value does not have a parent.");
            }
            qd.primaryDatastoreQuery.addFilter("__key__", Query.FilterOperator.EQUAL, (Object)valueKey.getParent());
        } else {
            if (valueKey == null) {
                throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": The datastore does not support querying for objects with null parents.");
            }
            this.addParentFilter(op, valueKey, qd.primaryDatastoreQuery);
        }
    }

    private void verifyRelatedKeyIsOfProperType(AbstractMemberMetaData ammd, Key key, AbstractClassMetaData acmd) {
        String fieldKind;
        String keyKind = key.getKind();
        if (!keyKind.equals(fieldKind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName())) {
            throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " maps to kind " + fieldKind + " but" + " parameter value contains Key of kind " + keyKind);
        }
    }

    private String determinePropertyName(AbstractMemberMetaData ammd) {
        if (ammd.hasExtension("gae.pk-id") || ammd.hasExtension("gae.pk-name")) {
            throw new FatalNucleusUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " is a sub-component of the primary key.  The " + "datastore does not support filtering or sorting by primary key components, only the " + "entire primary key.");
        }
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length != 0) {
            return ammd.getColumnMetaData()[0].getName();
        }
        if (ammd.getElementMetaData() != null && ammd.getElementMetaData().getColumnMetaData() != null && ammd.getElementMetaData().getColumnMetaData().length != 0) {
            return ammd.getElementMetaData().getColumnMetaData()[0].getName();
        }
        return this.getIdentifierFactory().newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    private Key internalPkToKey(AbstractClassMetaData acmd, Object internalPk) {
        Key key;
        if (internalPk instanceof String) {
            try {
                key = KeyFactory.stringToKey((String)((String)internalPk));
            }
            catch (IllegalArgumentException iae) {
                String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
                key = KeyFactory.createKey((String)kind, (String)((String)internalPk));
            }
        } else if (internalPk instanceof Long) {
            String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            key = KeyFactory.createKey((String)kind, (long)((Long)internalPk));
        } else {
            key = (Key)internalPk;
        }
        return key;
    }

    private void addParentFilter(Query.FilterOperator op, Key key, com.google.appengine.api.datastore.Query datastoreQuery) {
        if (op != Query.FilterOperator.EQUAL) {
            throw new UnsupportedDatastoreFeatureException("Operator is of type " + op + " but the " + "datastore only supports parent queries using the equality operator.");
        }
        if (key == null) {
            throw new UnsupportedDatastoreFeatureException("Received a null parent parameter.  The datastore does not support querying for null parents.");
        }
        datastoreQuery.setAncestor(key);
    }

    private void checkForUnsupportedOperator(Expression.Operator operator) {
        if (UNSUPPORTED_OPERATORS.contains(operator)) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
        }
    }

    private boolean isParentPK(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.parent-pk");
    }

    com.google.appengine.api.datastore.Query getLatestDatastoreQuery() {
        return this.latestDatastoreQuery;
    }

    private ObjectManager getObjectManager() {
        return this.query.getObjectManager();
    }

    private DatastoreManager getDatastoreManager() {
        return (DatastoreManager)this.getObjectManager().getStoreManager();
    }

    private MetaDataManager getMetaDataManager() {
        return this.getObjectManager().getMetaDataManager();
    }

    private ClassLoaderResolver getClassLoaderResolver() {
        return this.getObjectManager().getClassLoaderResolver();
    }

    public static interface NowProvider {
        public Date now();
    }

    class UnsupportedDatastoreFeatureException
    extends UnsupportedOperationException {
        UnsupportedDatastoreFeatureException(String msg) {
            super("Problem with query <" + DatastoreQuery.this.query.getSingleStringQuery() + ">: " + msg);
        }
    }

    static class UnsupportedDatastoreOperatorException
    extends UnsupportedOperationException {
        private final String queryString;
        private final Expression.Operator operator;
        private final String msg;

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator) {
            this(queryString, operator, null);
        }

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator, String msg) {
            super(queryString);
            this.queryString = queryString;
            this.operator = operator;
            this.msg = msg;
        }

        public String getMessage() {
            return "Problem with query <" + this.queryString + ">: App Engine datastore does not support operator " + this.operator + ".  " + (this.msg == null ? "" : this.msg);
        }

        public Expression.Operator getOperation() {
            return this.operator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultType {
        ENTITY,
        ENTITY_PROJECTION,
        COUNT,
        KEYS_ONLY;

    }
}

