/*
 * Decompiled with CFR 0.152.
 */
package jni.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jni.utils.StreamUtils;

public final class JniUtils {
    private static List<String> loadedLibraries = new ArrayList<String>();

    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("The " + name + " must not be null.");
        }
    }

    public static boolean extractFromJarToTemp(String filename) {
        return JniUtils.extractFromJar(filename, filename, System.getProperty("java.io.tmpdir"));
    }

    public static boolean extractFromJar(String filename, String destinationDirectory) {
        return JniUtils.extractFromJar(filename, filename, destinationDirectory);
    }

    public static boolean extractFromJar(String searchString, String filename, String destinationDirectory) {
        boolean extracted = JniUtils.extractFromJarZipMethod(filename, filename, destinationDirectory);
        if (!extracted) {
            JniUtils.extractFromJarUsingClassLoader(filename, filename, destinationDirectory);
        }
        return extracted;
    }

    private static boolean extractFromJarZipMethod(String searchString, String filename, String destinationDirectory) {
        boolean extracted = false;
        String classpath = JniUtils.getExtendedClasspath();
        File jarfile = null;
        byte[] buf = new byte[1024];
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens() && !extracted) {
            String jarFileName = st.nextToken();
            jarfile = new File(jarFileName);
            if (!jarfile.exists() || !jarfile.isFile()) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(jarFileName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ZipInputStream zis = new ZipInputStream(bis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    int n;
                    File destFile;
                    if (!ze.getName().endsWith(searchString)) continue;
                    if (!destinationDirectory.endsWith(File.separator)) {
                        destinationDirectory = destinationDirectory + File.separator;
                    }
                    if ((destFile = new File(destinationDirectory + filename)).exists()) {
                        destFile.delete();
                    }
                    FileOutputStream fileoutputstream = new FileOutputStream(destinationDirectory + filename);
                    while ((n = zis.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    fileoutputstream.close();
                    extracted = true;
                    destFile.deleteOnExit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                extracted = false;
            }
        }
        return extracted;
    }

    private static boolean extractFromJarUsingClassLoader(String searchString, String filename, String destinationDirectory) {
        ClassLoader cl = null;
        try {
            Class<?> clClass = Class.forName("com.simontuffs.onejar.JarClassLoader");
            Constructor<?>[] constructor = clClass.getConstructors();
            cl = (ClassLoader)constructor[1].newInstance(ClassLoader.getSystemClassLoader());
            System.out.println("Loaded JarClassLoader. cl=" + cl.toString());
        }
        catch (Throwable e) {
            cl = ClassLoader.getSystemClassLoader();
        }
        URL liburl = cl.getResource(filename);
        if (liburl == null) {
            return false;
        }
        if (!destinationDirectory.endsWith(File.separator)) {
            destinationDirectory = destinationDirectory + File.separator;
        }
        try {
            File destFile = new File(destinationDirectory + filename);
            if (destFile.exists()) {
                destFile.delete();
            }
            InputStream is = liburl.openStream();
            FileOutputStream os = new FileOutputStream(destinationDirectory + filename);
            byte[] buf = new byte[4096];
            int cnt = is.read(buf);
            while (cnt > 0) {
                ((OutputStream)os).write(buf, 0, cnt);
                cnt = is.read(buf);
            }
            ((OutputStream)os).close();
            is.close();
            destFile.deleteOnExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isInJar(String searchString) {
        boolean found = false;
        String classpath = JniUtils.getExtendedClasspath();
        File jarfile = null;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens() && !found) {
            String jarFileName = st.nextToken();
            jarfile = new File(jarFileName);
            if (!jarfile.exists() || !jarfile.isFile()) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(jarFileName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ZipInputStream zis = new ZipInputStream(bis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (!ze.getName().endsWith(searchString)) continue;
                    found = true;
                }
            }
            catch (Exception e) {
                found = false;
            }
        }
        return found;
    }

    private static String getLibrarySearchPath() {
        return System.getProperty("java.library.path") + File.pathSeparatorChar + System.getProperty("user.dir") + File.pathSeparatorChar;
    }

    private static String getExtendedClasspath() {
        String classpath = System.getProperty("java.class.path") + File.pathSeparatorChar;
        String userDirStr = System.getProperty("user.dir");
        File userDir = new File(userDirStr);
        if (!(userDirStr = userDir.getAbsolutePath()).endsWith(File.separator)) {
            userDirStr = userDirStr + File.separator;
        }
        String[] files = userDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith("jar")) continue;
            classpath = classpath + File.pathSeparatorChar + userDirStr + files[i];
        }
        return classpath;
    }

    public static boolean checkLibraryInPath(String libFilename) {
        boolean libfilefound = false;
        String libpath = JniUtils.getLibrarySearchPath();
        File libfile = new File("");
        StringTokenizer st = new StringTokenizer(libpath, File.pathSeparator);
        while (st.hasMoreTokens() && !libfilefound) {
            libfile = new File(st.nextToken() + File.separatorChar + libFilename);
            libfilefound = libfile.exists();
        }
        return libfilefound;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = JniUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String libraryName) {
        List<String> list = loadedLibraries;
        synchronized (list) {
            if (loadedLibraries.contains(libraryName)) {
                return;
            }
            try {
                System.loadLibrary(libraryName);
            }
            catch (UnsatisfiedLinkError err) {
                File libraryFile;
                String libraryFileName = System.mapLibraryName(libraryName);
                URL url = JniUtils.class.getResource("/" + libraryFileName);
                if (url.getProtocol().toLowerCase().equals("file")) {
                    try {
                        libraryFile = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("UTF-8 is not supported encoding.");
                    }
                } else {
                    JniUtils.cleanUpOldLibraryFiles(libraryFileName);
                    libraryFile = JniUtils.createTempLibraryFile(libraryFileName);
                }
                JniUtils.rehydrateFrameworkAtLibraryPath(libraryFile);
                try {
                    System.load(libraryFile.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError e) {
                    throw new RuntimeException("Loading " + libraryFileName + " failed.\n" + e.getMessage());
                }
            }
            loadedLibraries.add(libraryName);
        }
    }

    private static void rehydrateFrameworkAtLibraryPath(File libraryFile) {
        if (!libraryFile.getName().endsWith("jnilib")) {
            return;
        }
        try {
            File skypeFramework = new File(libraryFile.getCanonicalFile().getParentFile(), "Skype.Framework");
            InputStream skypeFrameworkStream = JniUtils.class.getResourceAsStream("/Skype.Framework");
            StreamUtils.writeStreamToFile(skypeFrameworkStream, skypeFramework);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void cleanUpOldLibraryFiles(String libraryFileName) {
        final String fileNamePrefix = libraryFileName.substring(0, libraryFileName.indexOf(46));
        final String extension = libraryFileName.substring(libraryFileName.lastIndexOf(46));
        for (File file : new File(System.getProperty("java.io.tmpdir")).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(fileNamePrefix) && name.endsWith(extension);
            }
        })) {
            file.delete();
        }
    }

    private static File createTempLibraryFile(String libraryFileName) {
        InputStream in = JniUtils.class.getResourceAsStream("/" + libraryFileName);
        if (in == null) {
            throw new RuntimeException(libraryFileName + " is not contained in the jar.");
        }
        FileOutputStream out = null;
        try {
            String fileNamePrefix = libraryFileName.substring(0, libraryFileName.indexOf(46));
            String extension = libraryFileName.substring(libraryFileName.lastIndexOf(46));
            File file = StreamUtils.getStreamAsTempFile(in, fileNamePrefix, extension);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException("Writing " + libraryFileName + " failed.");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private JniUtils() {
    }
}

