/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.PlaceholderScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class InitialScopeExtractor {
    private ASTManipulator manipulator = new ASTManipulator();
    private IScope currentScope;
    private List<PlaceholderScope> importsPlaceholders;

    public IScope extractScope(ASTCssNode node) {
        this.currentScope = null;
        this.importsPlaceholders = new LinkedList<PlaceholderScope>();
        IScope result = this.buildScope(node);
        return result;
    }

    private IScope buildScope(ASTCssNode node) {
        boolean hasOwnScope = AstLogic.hasOwnScope(node);
        if (hasOwnScope) {
            this.increaseScope(node);
        }
        this.fillScopeNames(node);
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            IScope bodyScope;
            this.buildScope(aSTCssNode);
            if (aSTCssNode.getType() == ASTCssNodeType.IMPORT) {
                this.importsPlaceholders.add(this.createPlaceholderScope(aSTCssNode));
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                this.currentScope.registerVariable((VariableDeclaration)aSTCssNode);
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.REUSABLE_STRUCTURE) {
                ReusableStructure mixin = (ReusableStructure)aSTCssNode;
                bodyScope = this.currentScope.childByOwners(mixin, mixin.getBody());
                this.currentScope.registerMixin(mixin, bodyScope);
                bodyScope.removedFromAst();
                if (bodyScope.hasParent()) {
                    bodyScope.getParent().removedFromAst();
                }
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.RULE_SET) {
                RuleSet ruleSet = (RuleSet)aSTCssNode;
                if (!ruleSet.isUsableAsReusableStructure()) continue;
                bodyScope = this.currentScope.childByOwners(ruleSet, ruleSet.getBody());
                this.currentScope.registerMixin(ruleSet.convertToReusableStructure(), bodyScope);
                continue;
            }
            if (aSTCssNode.getType() != ASTCssNodeType.MIXIN_REFERENCE) continue;
            this.currentScope.createDataPlaceholder();
        }
        IScope result = this.currentScope;
        if (hasOwnScope) {
            this.decreaseScope();
        }
        return result;
    }

    private void fillScopeNames(ASTCssNode node) {
        switch (node.getType()) {
            case REUSABLE_STRUCTURE: {
                this.currentScope.addNames(((ReusableStructure)node).getNamesAsStrings());
                break;
            }
            case RULE_SET: {
                RuleSet ruleSet = (RuleSet)node;
                if (!ruleSet.isUsableAsReusableStructure()) break;
                this.currentScope.addNames(ruleSet.extractReusableStructureNames());
                break;
            }
        }
    }

    private void decreaseScope() {
        this.currentScope = this.currentScope.getParent();
    }

    private void increaseScope(ASTCssNode owner) {
        this.currentScope = this.currentScope == null ? ScopeFactory.createDefaultScope(owner) : (AstLogic.isBodyOwner(owner) ? ScopeFactory.createBodyOwnerScope(owner, this.currentScope) : ScopeFactory.createScope(owner, this.currentScope));
    }

    private PlaceholderScope createPlaceholderScope(ASTCssNode owner) {
        if (this.currentScope == null) {
            throw new BugHappened("No parent scope available.", owner);
        }
        return ScopeFactory.createPlaceholderScope(owner, this.currentScope);
    }

    public List<PlaceholderScope> getImportsPlaceholders() {
        return this.importsPlaceholders;
    }
}

