/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions.strings;

import com.github.sommeri.less4j.core.compiler.expressions.strings.MatchRange;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractStringReplacer<ARG> {
    public String replaceIn(String originalValue, ARG replacementArgument, HiddenTokenAwareTree technicalUnderlying) {
        StringBuilder result = new StringBuilder();
        List<MatchRange> matches = this.findMatches(originalValue);
        int lastEnd = 0;
        for (MatchRange matchRange : matches) {
            result.append(originalValue.substring(lastEnd, matchRange.getFrom()));
            result.append(this.replacementValue(replacementArgument, technicalUnderlying, matchRange));
            lastEnd = matchRange.getTo();
        }
        if (lastEnd < originalValue.length()) {
            result.append(originalValue.substring(lastEnd));
        }
        return result.toString();
    }

    private List<MatchRange> findMatches(String originalValue) {
        ArrayList<MatchRange> result = new ArrayList<MatchRange>();
        Matcher matcher = this.getPattern().matcher(originalValue);
        while (matcher.find()) {
            result.add(this.createMatchRange(matcher));
        }
        return result;
    }

    private MatchRange createMatchRange(Matcher matcher) {
        String group = matcher.group();
        return new MatchRange(matcher.start(), matcher.end(), this.extractMatchName(group), group);
    }

    protected abstract String extractMatchName(String var1);

    protected abstract Pattern getPattern();

    protected abstract String replacementValue(ARG var1, HiddenTokenAwareTree var2, MatchRange var3);
}

