/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsManipulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UselessLessElementsRemover {
    public void removeUselessLessElements(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                this.removeFrom((RuleSet)node);
                break;
            }
            case CHARSET_DECLARATION: 
            case IMPORT: {
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.removeUselessLessElements(aSTCssNode);
                }
            }
        }
    }

    private void removeFrom(RuleSet ruleSet) {
        List<Selector> selectors = ruleSet.getSelectors();
        for (Selector selector : selectors) {
            this.removeFrom(selector, ruleSet);
        }
    }

    private void removeFrom(Selector selector, RuleSet parentRuleSet) {
        if (!(selector = this.replaceLeadingAppendersByEmptiness(selector, parentRuleSet)).containsAppender()) {
            return;
        }
        SelectorsManipulator manipulator = new SelectorsManipulator();
        Selector empty = new Selector(selector.getUnderlyingStructure(), this.createEmptySimpleSelector(selector));
        List<Selector> replaceAppenders = manipulator.replaceAppenders(selector, Arrays.asList(empty));
        Selector replacement = replaceAppenders.get(0);
        parentRuleSet.replaceSelector(selector, replacement);
    }

    private Selector replaceLeadingAppendersByEmptiness(Selector selector, RuleSet parentRuleSet) {
        while (!selector.isEmpty() && selector.getHead().isAppender()) {
            selector.getHead().setParent(null);
            selector.removeHead();
        }
        if (selector.isEmpty()) {
            SimpleSelector empty = this.createEmptySimpleSelector(selector);
            selector.addPart(empty);
        }
        return selector;
    }

    private SimpleSelector createEmptySimpleSelector(ASTCssNode underlyingStructureSource) {
        SimpleSelector empty = new SimpleSelector(underlyingStructureSource.getUnderlyingStructure(), null, null, true);
        empty.setEmptyForm(true);
        return empty;
    }
}

