/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.validators;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.validators.SupportedCSSBodyMembers;
import java.util.ArrayList;
import java.util.Set;

public class CssAstValidator {
    private final ProblemsHandler problemsHandler;
    private final SupportedCSSBodyMembers allowedBodyMembers = new SupportedCSSBodyMembers();

    public CssAstValidator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void validate(ASTCssNode node) {
        if (node instanceof Body) {
            this.validateBody((Body)node);
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.validate(aSTCssNode);
        }
    }

    private void validateBody(Body node) {
        Set<ASTCssNodeType> supportedMembers = this.allowedBodyMembers.getSupportedMembers(node);
        for (ASTCssNode member : node.getMembers()) {
            if (supportedMembers.contains((Object)member.getType())) continue;
            this.problemsHandler.wrongMemberInCssBody(member, node);
        }
    }
}

