/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class ParenthesesExpression
extends Expression {
    private Expression enclosedExpression;

    public ParenthesesExpression(HiddenTokenAwareTree token, Expression enclosedExpression) {
        super(token);
        this.enclosedExpression = enclosedExpression;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.enclosedExpression);
    }

    public Expression getEnclosedExpression() {
        return this.enclosedExpression;
    }

    public void setEnclosedExpression(Expression enclosedExpression) {
        this.enclosedExpression = enclosedExpression;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.PARENTHESES_EXPRESSION;
    }

    public String toString() {
        return "(" + this.enclosedExpression + ")";
    }

    @Override
    public ParenthesesExpression clone() {
        ParenthesesExpression result = (ParenthesesExpression)super.clone();
        result.enclosedExpression = this.enclosedExpression == null ? null : this.enclosedExpression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

