/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Declaration
extends ASTCssNode {
    private InterpolableName name;
    private Expression expression;
    private boolean important;
    private boolean merging;

    public Declaration(HiddenTokenAwareTree token, InterpolableName name) {
        this(token, name, null, false, false);
    }

    public Declaration(HiddenTokenAwareTree token, InterpolableName name, Expression expression, boolean merging) {
        this(token, name, expression, false, merging);
    }

    public Declaration(HiddenTokenAwareTree token, InterpolableName name, Expression expression, boolean important, boolean merging) {
        super(token);
        this.name = name;
        this.expression = expression;
        this.important = important;
        this.merging = merging;
    }

    public String getNameAsString() {
        return this.name.getName();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isImportant() {
        return this.important;
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void setName(InterpolableName name) {
        this.name = name;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public void setMerging(boolean merging) {
        this.merging = merging;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DECLARATION;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression, this.name);
    }

    public boolean isFontDeclaration() {
        return this.getNameAsString() != null ? this.getNameAsString().toLowerCase().equals("font") : false;
    }

    public boolean isFilterDeclaration() {
        return this.getNameAsString() != null ? this.getNameAsString().toLowerCase().endsWith("filter") : false;
    }

    public String toString() {
        return "" + this.name + ":" + this.expression;
    }

    @Override
    public Declaration clone() {
        Declaration result = (Declaration)super.clone();
        result.name = this.name == null ? null : this.name.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

