/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.PatternsComparator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

public class MixinsReferenceMatcher {
    private ExpressionEvaluator evaluator;
    private ExpressionComparator comparator = new PatternsComparator();

    public MixinsReferenceMatcher(IScope scope, ProblemsHandler problemsHandler) {
        this.evaluator = new ExpressionEvaluator(scope, problemsHandler);
    }

    public List<FullMixinDefinition> filter(MixinReference reference, List<FullMixinDefinition> mixins) {
        int requiredNumber = reference.getNumberOfDeclaredParameters();
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixin : mixins) {
            if (!this.hasRightNumberOfParameters(mixin.getMixin(), requiredNumber) || !this.patternsMatch(reference, mixin.getMixin())) continue;
            result.add(mixin);
        }
        return result;
    }

    private boolean hasRightNumberOfParameters(ReusableStructure mixin, int requiredNumber) {
        int allDefined = mixin.getParameters().size();
        int mandatory = mixin.getMandatoryParameters().size();
        boolean hasRightNumberOfParameters = requiredNumber >= mandatory && (requiredNumber <= allDefined || mixin.hasCollectorParameter());
        return hasRightNumberOfParameters;
    }

    private boolean patternsMatch(MixinReference reference, ReusableStructure mixin) {
        int i = 0;
        for (ASTCssNode parameter : mixin.getParameters()) {
            if (parameter instanceof Expression) {
                if (!reference.hasPositionalParameter(i)) {
                    return false;
                }
                Expression pattern = (Expression)parameter;
                if (!this.comparator.equal(pattern, this.evaluator.evaluate(reference.getPositionalParameter(i)))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

