/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.ArgumentsBuilder;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

class MixinsSolver {
    private final ProblemsHandler problemsHandler;
    private final ReferencesSolver parentSolver;

    public MixinsSolver(ReferencesSolver parentSolver, ProblemsHandler problemsHandler) {
        this.parentSolver = parentSolver;
        this.problemsHandler = problemsHandler;
    }

    private void resolveMixinReference(final GeneralBody result, final Scope callerScope, final ReusableStructure referencedMixin, final Scope referencedMixinScope, final ExpressionEvaluator expressionEvaluator) {
        InScopeSnapshotRunner.runInLocalDataSnapshot(referencedMixinScope, new InScopeSnapshotRunner.ITask(){

            @Override
            public void run() {
                MixinsSolver.this.unsafeResolveMixinReference(result, callerScope, referencedMixin, referencedMixinScope, expressionEvaluator);
            }
        });
    }

    private void unsafeResolveMixinReference(GeneralBody result, Scope callerScope, ReusableStructure referencedMixin, Scope referencedMixinScopeSnapshot, ExpressionEvaluator expressionEvaluator) {
        GeneralBody bodyClone = referencedMixin.getBody().clone();
        this.parentSolver.doSolveReferences((ASTCssNode)bodyClone, referencedMixinScopeSnapshot);
        result.addMembers(bodyClone.getMembers());
        Scope returnValues = expressionEvaluator.evaluateValues(referencedMixinScopeSnapshot);
        List<FullMixinDefinition> allMixinsToImport = this.mixinsToImport(callerScope, referencedMixin, referencedMixinScopeSnapshot);
        returnValues.addAllMixins(allMixinsToImport);
        callerScope.addToPlaceholder(returnValues);
    }

    private List<FullMixinDefinition> mixinsToImport(Scope referenceScope, ReusableStructure referencedMixin, Scope referencedMixinScope) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixinToImport : referencedMixinScope.getAllMixins()) {
            Scope scopeTreeCopy;
            boolean canHaveArguments = AstLogic.canHaveArguments(referencedMixin);
            boolean isLocalImport = mixinToImport.getScope().seesLocalDataOf(referenceScope);
            if (!canHaveArguments) {
                result.add(new FullMixinDefinition(mixinToImport.getMixin(), mixinToImport.getScope()));
                continue;
            }
            if (isLocalImport) {
                scopeTreeCopy = mixinToImport.getScope().copyWholeTree();
                result.add(new FullMixinDefinition(mixinToImport.getMixin(), scopeTreeCopy));
                continue;
            }
            scopeTreeCopy = mixinToImport.getScope().copyWholeTree();
            scopeTreeCopy.getRootScope().setParent(referencedMixinScope.copyWithParentsChain());
            result.add(new FullMixinDefinition(mixinToImport.getMixin(), scopeTreeCopy));
        }
        return result;
    }

    private void shiftComments(MixinReference reference, GeneralBody result) {
        List<ASTCssNode> childs = result.getMembers();
        if (!childs.isEmpty()) {
            childs.get(0).addOpeningComments(reference.getOpeningComments());
            childs.get(childs.size() - 1).addTrailingComments(reference.getTrailingComments());
        }
    }

    private Scope buildMixinsArguments(MixinReference reference, Scope referenceScope, FullMixinDefinition mixin) {
        ArgumentsBuilder builder = new ArgumentsBuilder(reference, mixin.getMixin(), new ExpressionEvaluator(referenceScope, this.problemsHandler), this.problemsHandler);
        return builder.build();
    }

    public GeneralBody buildMixinReferenceReplacement(final MixinReference reference, final Scope callerScope, List<FullMixinDefinition> mixins) {
        final GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        for (final FullMixinDefinition fullMixin : mixins) {
            final ReusableStructure mixin = fullMixin.getMixin();
            final Scope mixinScope = fullMixin.getScope();
            InScopeSnapshotRunner.runInLocalDataSnapshot(mixinScope.getParent(), new InScopeSnapshotRunner.ITask(){

                @Override
                public void run() {
                    Scope mixinArguments = MixinsSolver.this.buildMixinsArguments(reference, callerScope, fullMixin);
                    Scope mixinWorkingScope = MixinsSolver.calculateMixinsWorkingScope(callerScope, mixinArguments, mixinScope);
                    ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(mixinWorkingScope, MixinsSolver.this.problemsHandler);
                    if (expressionEvaluator.guardsSatisfied(mixin)) {
                        MixinsSolver.this.resolveMixinReference(result, callerScope, fullMixin.getMixin(), mixinWorkingScope, expressionEvaluator);
                    }
                }
            });
        }
        callerScope.closePlaceholder();
        this.resolveImportance(reference, result);
        this.shiftComments(reference, result);
        return result;
    }

    private void resolveImportance(MixinReference reference, GeneralBody result) {
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
    }

    private void declarationsAreImportant(Body result) {
        for (ASTCssNode kid : result.getMembers()) {
            if (kid instanceof Declaration) {
                Declaration declaration = (Declaration)kid;
                declaration.setImportant(true);
                continue;
            }
            if (!(kid instanceof BodyOwner)) continue;
            BodyOwner owner = (BodyOwner)((Object)kid);
            this.declarationsAreImportant((Body)owner.getBody());
        }
    }

    private static Scope calculateMixinsWorkingScope(Scope callerScope, Scope arguments, Scope mixinScope) {
        Scope mixinDeclarationScope = mixinScope.getParent();
        mixinDeclarationScope.add(arguments);
        boolean isLocalImport = mixinDeclarationScope.seesLocalDataOf(callerScope);
        if (isLocalImport) {
            return mixinScope;
        }
        Scope result = mixinScope.copyWholeTree();
        result.getRootScope().setParent(callerScope.copyWithParentsChain());
        return result;
    }
}

