/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import java.util.ArrayList;

public class InitialScopeExtractor {
    private ASTManipulator manipulator = new ASTManipulator();
    private Scope currentScope;

    public Scope extractScope(ASTCssNode node) {
        this.currentScope = null;
        Scope result = this.buildScope(node);
        return result;
    }

    private Scope buildScope(ASTCssNode node) {
        boolean hasOwnScope = AstLogic.hasOwnScope(node);
        if (hasOwnScope) {
            this.increaseScope(node);
        }
        this.fillScopeNames(node);
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            Scope bodyScope;
            this.buildScope(aSTCssNode);
            if (aSTCssNode.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                this.currentScope.registerVariable((VariableDeclaration)aSTCssNode);
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.REUSABLE_STRUCTURE) {
                ReusableStructure mixin = (ReusableStructure)aSTCssNode;
                bodyScope = this.currentScope.childByOwners(mixin, mixin.getBody());
                this.currentScope.registerMixin(mixin, bodyScope);
                bodyScope.removedFromTree();
                if (bodyScope.hasParent()) {
                    bodyScope.getParent().removedFromTree();
                }
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.RULE_SET) {
                RuleSet ruleSet = (RuleSet)aSTCssNode;
                if (!ruleSet.usableAsReusableStructure()) continue;
                bodyScope = this.currentScope.childByOwners(ruleSet, ruleSet.getBody());
                this.currentScope.registerMixin(ruleSet.convertToReusableStructure(), bodyScope);
                continue;
            }
            if (aSTCssNode.getType() != ASTCssNodeType.MIXIN_REFERENCE) continue;
            this.currentScope.createPlaceholder();
        }
        Scope result = this.currentScope;
        if (hasOwnScope) {
            this.decreaseScope();
        }
        return result;
    }

    private void fillScopeNames(ASTCssNode node) {
        switch (node.getType()) {
            case REUSABLE_STRUCTURE: {
                this.currentScope.addNames(((ReusableStructure)node).getNamesAsStrings());
                break;
            }
            case RULE_SET: {
                RuleSet ruleSet = (RuleSet)node;
                if (!ruleSet.usableAsReusableStructure()) break;
                this.currentScope.addNames(ruleSet.extractReusableStructureNames());
                break;
            }
        }
    }

    private void decreaseScope() {
        this.currentScope = this.currentScope.getParent();
    }

    private void increaseScope(ASTCssNode owner) {
        this.currentScope = this.currentScope == null ? Scope.createDefaultScope(owner) : (AstLogic.isBodyOwner(owner) ? Scope.createBodyOwnerScope(owner, this.currentScope) : Scope.createScope(owner, this.currentScope));
    }
}

