/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.Placeholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MixinsDefinitionsStorage
implements Cloneable {
    private Map<String, List<FullMixinDefinition>> storage = new HashMap<String, List<FullMixinDefinition>>();
    private LinkedList<Placeholder> openPlaceholders = new LinkedList();

    public void store(FullMixinDefinition mixin) {
        List<ReusableStructureName> names = mixin.getMixin().getNames();
        for (ReusableStructureName name : names) {
            this.doStore(name.asString(), mixin);
        }
    }

    public void store(String name, List<FullMixinDefinition> value) {
        this.doStore(name, value);
    }

    public void storeAll(List<FullMixinDefinition> mixins) {
        for (FullMixinDefinition mixin : mixins) {
            this.store(mixin);
        }
    }

    public void storeAll(MixinsDefinitionsStorage otherStorage) {
        for (List<FullMixinDefinition> list : otherStorage.storage.values()) {
            this.storeAll(list);
        }
    }

    public List<FullMixinDefinition> getMixins(ReusableStructureName name) {
        return this.storage.get(name.asString());
    }

    public List<FullMixinDefinition> getAllMixins() {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (List<FullMixinDefinition> value : this.storage.values()) {
            result.addAll(value);
        }
        return result;
    }

    protected void doStore(String name, FullMixinDefinition mixin) {
        List<FullMixinDefinition> list = this.getStoredList(name);
        list.add(mixin);
        this.updatePlaceholdersPositions(name, mixin);
    }

    protected void doStore(String name, List<FullMixinDefinition> mixins) {
        List<FullMixinDefinition> list = this.getStoredList(name);
        list.addAll(mixins);
        this.updatePlaceholdersPositions(name, mixins);
    }

    private void updatePlaceholdersPositions(String name, List<FullMixinDefinition> mixins) {
        if (!mixins.isEmpty()) {
            this.updatePlaceholdersPositions(name, mixins.get(0));
        }
    }

    private void updatePlaceholdersPositions(String name, FullMixinDefinition mixin) {
        Iterator<Placeholder> iterator = this.openPlaceholders.descendingIterator();
        if (!iterator.hasNext()) {
            return;
        }
        Placeholder placeholder = iterator.next();
        while (!placeholder.knowPosition(name)) {
            placeholder.setPosition(name, mixin);
            if (!iterator.hasNext()) continue;
            placeholder = iterator.next();
        }
    }

    protected List<FullMixinDefinition> getStoredList(String name) {
        List<FullMixinDefinition> list = this.storage.get(name);
        if (list == null) {
            list = new ArrayList<FullMixinDefinition>();
            this.storage.put(name, list);
        }
        return list;
    }

    public boolean contains(ReusableStructureName name) {
        return this.contains(name.asString());
    }

    public boolean contains(String name) {
        return this.storage.containsKey(name);
    }

    public int size() {
        return this.storage.size();
    }

    public void addToPlaceholder(MixinsDefinitionsStorage otherStorage) {
        Placeholder placeholder = this.openPlaceholders.peekFirst();
        Map<String, List<FullMixinDefinition>> otherMixins = otherStorage.storage;
        for (Map.Entry<String, List<FullMixinDefinition>> entry : otherMixins.entrySet()) {
            String name = entry.getKey();
            List<FullMixinDefinition> values = entry.getValue();
            placeholder.addToSelf(name, values);
        }
    }

    public void addAll(MixinsDefinitionsStorage source) {
        for (Map.Entry<String, List<FullMixinDefinition>> entry : source.storage.entrySet()) {
            String name = entry.getKey();
            List<FullMixinDefinition> values = entry.getValue();
            this.store(name, values);
        }
    }

    public void createPlaceholder() {
        this.openPlaceholders.add(new Placeholder(this));
    }

    public void closePlaceholder() {
        this.openPlaceholders.pop();
    }

    public String placeholdersReport() {
        return "unused: " + this.openPlaceholders.size();
    }

    public MixinsDefinitionsStorage clone() {
        try {
            MixinsDefinitionsStorage clone = (MixinsDefinitionsStorage)super.clone();
            clone.storage = new HashMap<String, List<FullMixinDefinition>>(this.storage);
            clone.openPlaceholders = this.clonePlaceholders(this.openPlaceholders, clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    protected LinkedList<Placeholder> clonePlaceholders(LinkedList<Placeholder> placeholders, MixinsDefinitionsStorage ownerClone) {
        LinkedList<Placeholder> result = new LinkedList<Placeholder>();
        for (Placeholder placeholder : placeholders) {
            result.add(placeholder.clone(ownerClone));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("\n");
        result.append("Mixins: ").append(this.storage.keySet());
        return result.toString();
    }
}

