/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.LessAstValidator;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;

public class ASTBuilder {
    private final ProblemsHandler problemsHandler;

    public ASTBuilder(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public StyleSheet parse(HiddenTokenAwareTree tree) {
        ASTBuilderSwitch builder = new ASTBuilderSwitch(this.problemsHandler);
        ASTCssNode result = (ASTCssNode)builder.switchOn(tree);
        this.convertComments(result);
        this.solveParentChildRelationShips(result);
        this.checkForWarnings(result);
        return (StyleSheet)result;
    }

    private void checkForWarnings(ASTCssNode result) {
        LessAstValidator validator = new LessAstValidator(this.problemsHandler);
        validator.validate(result);
    }

    private void solveParentChildRelationShips(ASTCssNode node) {
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            aSTCssNode.setParent(node);
            this.solveParentChildRelationShips(aSTCssNode);
        }
    }

    private void convertComments(ASTCssNode node) {
        this.inheritCommentsFromToken(node);
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            this.convertComments(aSTCssNode);
        }
    }

    private void inheritCommentsFromToken(ASTCssNode node) {
        HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
        if (underlyingStructure == null) {
            return;
        }
        List<Comment> preceding = this.convertToComments(underlyingStructure.getPreceding());
        node.setOpeningComments(preceding);
        List<Comment> following = this.convertToComments(underlyingStructure.getFollowing());
        node.setTrailingComments(following);
        List<Comment> orphans = this.convertToComments(underlyingStructure.getOrphans());
        node.setOrphanComments(orphans);
    }

    private List<Comment> convertToComments(List<Token> preceding) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        Comment comment = null;
        for (Token token : preceding) {
            if (token.getType() == 136) {
                comment = new Comment(new HiddenTokenAwareTree(token));
                result.add(comment);
            }
            if (token.getType() != 148 || comment == null) continue;
            comment.setHasNewLine(true);
        }
        return result;
    }
}

