/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import java.util.ArrayList;
import java.util.List;

public class ScopeExtractor {
    private ASTManipulator manipulator = new ASTManipulator();
    private Scope currentScope;
    private List<String> nextChildScopeNames;

    public Scope extractScope(ASTCssNode node) {
        this.currentScope = null;
        this.nextChildScopeNames = null;
        Scope result = this.buildScope(node);
        return result;
    }

    private Scope buildScope(ASTCssNode node) {
        List<String> representedNamespaces;
        boolean hasOwnScope = AstLogic.hasOwnScope(node);
        if (hasOwnScope) {
            this.increaseScope(node);
        }
        if ((representedNamespaces = this.representedNamedScope(node)) != null) {
            this.nextChildScopeNames = representedNamespaces;
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            RuleSet ruleSet;
            Scope bodyScope;
            this.buildScope(aSTCssNode);
            if (aSTCssNode.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                this.currentScope.registerVariable((VariableDeclaration)aSTCssNode);
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() == ASTCssNodeType.REUSABLE_STRUCTURE) {
                ReusableStructure mixin = (ReusableStructure)aSTCssNode;
                bodyScope = this.currentScope.getChildOwnerOf(mixin.getBody());
                this.currentScope.registerMixin(mixin, bodyScope);
                bodyScope.removedFromTree();
                this.manipulator.removeFromBody(aSTCssNode);
                continue;
            }
            if (aSTCssNode.getType() != ASTCssNodeType.RULE_SET || !(ruleSet = (RuleSet)aSTCssNode).usableAsReusableStructure()) continue;
            bodyScope = this.currentScope.getChildOwnerOf(ruleSet.getBody());
            this.currentScope.registerMixin(ruleSet.convertToReusableStructure(), bodyScope);
        }
        Scope result = this.currentScope;
        if (hasOwnScope) {
            this.decreaseScope();
        }
        return result;
    }

    private List<String> representedNamedScope(ASTCssNode node) {
        switch (node.getType()) {
            case REUSABLE_STRUCTURE: {
                return ((ReusableStructure)node).getNamesAsStrings();
            }
            case RULE_SET: {
                RuleSet ruleSet = (RuleSet)node;
                if (ruleSet.usableAsReusableStructure()) {
                    return ruleSet.extractReusableStructureNames();
                }
                return null;
            }
        }
        return null;
    }

    private void decreaseScope() {
        this.currentScope = this.currentScope.getParent();
    }

    private void increaseScope(ASTCssNode owner) {
        if (this.nextChildScopeNames == null) {
            this.currentScope = this.currentScope == null ? Scope.createDefaultScope(owner) : Scope.createUnnamedScope(owner, this.currentScope);
            return;
        }
        this.currentScope = Scope.createScope(owner, this.nextChildScopeNames, this.currentScope);
        this.nextChildScopeNames = null;
    }
}

