/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class FunctionExpression
extends Expression {
    private String name;
    private Expression parameter;

    public FunctionExpression(HiddenTokenAwareTree token, String name, Expression parameter) {
        super(token);
        this.name = name;
        this.parameter = parameter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getParameter() {
        return this.parameter;
    }

    public void setParameter(Expression parameter) {
        this.parameter = parameter;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.FUNCTION;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.parameter);
    }

    @Override
    public FunctionExpression clone() {
        FunctionExpression result = (FunctionExpression)super.clone();
        result.parameter = this.parameter == null ? null : this.parameter.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

