/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Body<T extends ASTCssNode>
extends ASTCssNode {
    private List<T> body = new ArrayList<T>();

    public Body(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public Body(HiddenTokenAwareTree underlyingStructure, List<T> declarations) {
        this(underlyingStructure);
        this.body.addAll(declarations);
    }

    public List<T> getChilds() {
        return this.body;
    }

    protected List<T> getBody() {
        return this.body;
    }

    public boolean isEmpty() {
        return this.body.isEmpty() && this.getOrphanComments().isEmpty();
    }

    public void addMembers(List<? extends T> members) {
        this.body.addAll(members);
    }

    public void addMembersAfter(List<? extends T> nestedRulesets, ASTCssNode kid) {
        int index = this.body.indexOf(kid);
        index = index == -1 ? this.body.size() : ++index;
        this.body.addAll(index, nestedRulesets);
    }

    public void addMember(T member) {
        this.body.add(member);
    }

    public void replaceMember(T oldMember, List<T> newMembers) {
        this.body.addAll(this.body.indexOf(oldMember), newMembers);
        this.body.remove(oldMember);
        ((ASTCssNode)oldMember).setParent(null);
        this.configureParentToAllChilds();
    }

    public List<T> membersByType(ASTCssNodeType type) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        List<T> body = this.getBody();
        for (ASTCssNode node : body) {
            if (node.getType() != type) continue;
            result.add(node);
        }
        return result;
    }

    public List<T> membersByNotType(ASTCssNodeType type) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        List<T> body = this.getBody();
        for (ASTCssNode node : body) {
            if (node.getType() == type) continue;
            result.add(node);
        }
        return result;
    }

    public boolean removeMember(T node) {
        return this.body.remove(node);
    }

    public Set<ASTCssNodeType> getSupportedMembers() {
        return new HashSet<ASTCssNodeType>(Arrays.asList(ASTCssNodeType.values()));
    }

    @Override
    public Body<T> clone() {
        Body result = (Body)super.clone();
        result.body = ArraysUtils.deeplyClonedList(this.body);
        result.configureParentToAllChilds();
        return result;
    }

    public List<T> getDeclarations() {
        return this.membersByType(ASTCssNodeType.DECLARATION);
    }

    public List<T> getNotDeclarations() {
        return this.membersByNotType(ASTCssNodeType.DECLARATION);
    }
}

