/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.InterpolableNamePart;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class InterpolableName
extends ASTCssNode {
    private List<InterpolableNamePart> parts = new ArrayList<InterpolableNamePart>();

    public InterpolableName(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public boolean isSimple() {
        if (this.parts == null || this.parts.size() != 1) {
            return false;
        }
        return this.parts.get(0).getType() == ASTCssNodeType.FIXED_NAME_PART;
    }

    public String getName() {
        String result = "";
        for (InterpolableNamePart part : this.parts) {
            result = result + part.getName();
        }
        return result;
    }

    public void add(InterpolableNamePart part) {
        this.parts.add(part);
    }

    public List<InterpolableNamePart> getParts() {
        return this.parts;
    }

    public void replaceMember(InterpolableNamePart oldMember, InterpolableNamePart newMember) {
        this.parts.add(this.parts.indexOf(oldMember), newMember);
        newMember.setParent(this);
        this.parts.remove(oldMember);
        oldMember.setParent(null);
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return this.parts;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.INTERPOLABLE_NAME;
    }

    @Override
    public InterpolableName clone() {
        InterpolableName clone = (InterpolableName)super.clone();
        clone.parts = ArraysUtils.deeplyClonedList(this.getParts());
        clone.configureParentToAllChilds();
        return clone;
    }

    public void extendName(String extension) {
        this.parts.add(new FixedNamePart(this.getUnderlyingStructure(), extension));
    }
}

