/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EmptyExpression;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.UnicodeRangeExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

public class TermBuilder {
    private final ASTBuilderSwitch parentBuilder;
    private ProblemsHandler problemsHandler = new ProblemsHandler();

    public TermBuilder(ASTBuilderSwitch astBuilderSwitch, ProblemsHandler problemsHandler) {
        this.parentBuilder = astBuilderSwitch;
        this.problemsHandler = problemsHandler;
    }

    public Expression buildFromTerm(HiddenTokenAwareTree token) {
        return this.buildFromTerm(token, 0);
    }

    public Expression buildFromTerm(HiddenTokenAwareTree token, int offsetChildIndx) {
        HiddenTokenAwareTree offsetChild = token.getChildren().get(offsetChildIndx);
        switch (offsetChild.getType()) {
            case 61: {
                return this.buildFromIdentifier(token, offsetChild);
            }
            case 53: {
                return this.buildFromString(token, offsetChild);
            }
            case 79: {
                return this.buildFromColorHash(token, offsetChild);
            }
            case 70: 
            case 72: {
                return this.negate(this.buildFromTerm(token, offsetChildIndx + 1), offsetChild);
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                return this.buildFromNumber(token, offsetChild);
            }
            case 107: {
                return this.buildFromSpecialFunction(token, offsetChild);
            }
            case 27: {
                return this.buildFromNormalFunction(token, offsetChild);
            }
            case 60: {
                return this.buildFromVariable(token, offsetChild);
            }
            case 66: {
                return this.buildFromIndirectVariable(token, offsetChild);
            }
            case 29: {
                return this.buildFromTerm(offsetChild);
            }
            case 15: {
                return this.buildFromParentheses(offsetChild);
            }
            case 16: {
                return this.buildFromEscapedValue(token, offsetChild);
            }
            case 106: {
                return this.buildFromUnicodeRange(token, offsetChild);
            }
        }
        throw new BugHappened("type number: " + PrintUtils.toName(offsetChild.getType()) + "(" + offsetChild.getType() + ") for " + offsetChild.getText(), offsetChild);
    }

    private Expression buildFromParentheses(HiddenTokenAwareTree first) {
        first.addBeforeFollowing(first.getLastChild().getFollowing());
        return new ParenthesesExpression(first, this.parentBuilder.handleExpression(first.getChild(1)));
    }

    private Expression buildFromColorHash(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        ColorExpression parsedColor = ConversionUtils.parseColor(token, text);
        if (parsedColor == null) {
            FaultyExpression faultyExpression = new FaultyExpression(token);
            this.problemsHandler.notAColor(faultyExpression, text);
            return faultyExpression;
        }
        return parsedColor;
    }

    private Expression negate(Expression value, HiddenTokenAwareTree sign) {
        if (value instanceof NumberExpression) {
            NumberExpression number = (NumberExpression)value;
            number.setExpliciteSign(true);
            if (sign.getType() == 72) {
                number.negate();
                number.setOriginalString("-" + number.getOriginalString());
            } else if (sign.getType() == 70) {
                number.setOriginalString("+" + number.getOriginalString());
            }
            return number;
        }
        if (sign.getType() == 72) {
            return new SignedExpression(sign, SignedExpression.Sign.MINUS, value);
        }
        return new SignedExpression(sign, SignedExpression.Sign.PLUS, value);
    }

    private NumberExpression buildFromNumber(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        NumberExpression result = new NumberExpression(token);
        String valueAsString = actual.getText().trim();
        this.setDoubleAndType(result, valueAsString);
        result.setOriginalString(valueAsString);
        result.setDimension(this.toDimension(actual));
        return result;
    }

    private void setDoubleAndType(NumberExpression result, String value) {
        value = value.toLowerCase().trim();
        String numberPart = value.replaceAll("[a-z%]", "");
        result.setValueAsDouble(Double.valueOf(numberPart));
        if (numberPart.length() < value.length()) {
            result.setSuffix(value.substring(numberPart.length()));
        } else {
            result.setSuffix("");
        }
    }

    private NumberExpression.Dimension toDimension(HiddenTokenAwareTree actual) {
        switch (actual.getType()) {
            case 83: {
                return NumberExpression.Dimension.NUMBER;
            }
            case 91: {
                return NumberExpression.Dimension.PERCENTAGE;
            }
            case 92: {
                return NumberExpression.Dimension.UNKNOWN;
            }
            case 90: {
                return NumberExpression.Dimension.REPEATER;
            }
            case 86: {
                return NumberExpression.Dimension.LENGTH;
            }
            case 84: {
                return NumberExpression.Dimension.EMS;
            }
            case 85: {
                return NumberExpression.Dimension.EXS;
            }
            case 87: {
                return NumberExpression.Dimension.ANGLE;
            }
            case 88: {
                return NumberExpression.Dimension.TIME;
            }
            case 89: {
                return NumberExpression.Dimension.FREQ;
            }
        }
        throw new BugHappened("Unknown dimension type: " + actual.getType() + " " + actual.getText(), actual);
    }

    public EscapedValue buildFromEscapedValue(HiddenTokenAwareTree token, HiddenTokenAwareTree offsetChild) {
        token.pushHiddenToKids();
        offsetChild.pushHiddenToKids();
        HiddenTokenAwareTree valueToken = offsetChild.getChild(0);
        String quotedText = valueToken.getText();
        return new EscapedValue(valueToken, quotedText.substring(2, quotedText.length() - 1));
    }

    private Expression buildFromString(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        return this.createCssString(token, text);
    }

    public CssString createCssString(HiddenTokenAwareTree token, String quotedText) {
        return new CssString(token, quotedText.substring(1, quotedText.length() - 1), quotedText.substring(0, 1));
    }

    private Expression buildFromIdentifier(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        String text = first.getText();
        if (NamedColorExpression.isColorName(text)) {
            return new NamedColorExpression(parent, text);
        }
        return new IdentifierExpression(parent, text);
    }

    private Expression buildFromUnicodeRange(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        return new UnicodeRangeExpression(parent, first.getText());
    }

    private FunctionExpression buildFromSpecialFunction(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        return new FunctionExpression(token, "url", this.extractUrlParameter(token, this.normalizeNewLineSymbols(first.getText())));
    }

    private String normalizeNewLineSymbols(String text) {
        return text.replaceAll("\r?\n", "\n");
    }

    private Expression extractUrlParameter(HiddenTokenAwareTree token, String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 5) {
            return new CssString(token, "", "");
        }
        String string = text.substring(4, text.length() - 1);
        return new CssString(token, string, "");
    }

    private FunctionExpression buildFromNormalFunction(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        List<HiddenTokenAwareTree> children = actual.getChildren();
        String name = this.buildFunctionName(children.get(0));
        if (children.size() == 1) {
            return new FunctionExpression(token, name, new EmptyExpression(token));
        }
        HiddenTokenAwareTree parameterNode = children.get(1);
        Expression parameter = (Expression)this.parentBuilder.switchOn(parameterNode);
        return new FunctionExpression(token, name, parameter);
    }

    private String buildFunctionName(HiddenTokenAwareTree token) {
        String result = "";
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            result = result + kid.getText();
        }
        return result;
    }

    public Variable buildFromVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromVariable(null, variableToken);
    }

    private Variable buildFromVariable(HiddenTokenAwareTree expressionToken, HiddenTokenAwareTree variableToken) {
        if (expressionToken != null) {
            expressionToken.addFollowing(variableToken.getFollowing());
            return new Variable(expressionToken, variableToken.getText());
        }
        return new Variable(variableToken, variableToken.getText());
    }

    public IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromIndirectVariable(null, variableToken);
    }

    private IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree expressionToken, HiddenTokenAwareTree variableToken) {
        if (expressionToken != null) {
            expressionToken.addFollowing(variableToken.getFollowing());
            return new IndirectVariable(expressionToken, variableToken.getText().substring(1));
        }
        return new IndirectVariable(variableToken, variableToken.getText().substring(1));
    }
}

