/*
 * Decompiled with CFR 0.152.
 */
package com.github.romankh3.image.comparison.model;

import java.awt.Point;
import java.util.Objects;

public class Rectangle {
    private Point minPoint;
    private Point maxPoint;

    private Rectangle() {
        this.minPoint = new Point();
        this.maxPoint = new Point();
    }

    public Rectangle(Rectangle rectangle) {
        this.minPoint = new Point(rectangle.getMinPoint().x, rectangle.getMinPoint().y);
        this.maxPoint = new Point(rectangle.getMaxPoint().x, rectangle.getMaxPoint().y);
    }

    public Rectangle(int minX, int minY, int maxX, int maxY) {
        this.minPoint = new Point(minX, minY);
        this.maxPoint = new Point(maxX, maxY);
    }

    public static Rectangle createDefault() {
        Rectangle defaultRectangle = new Rectangle();
        defaultRectangle.setDefaultValues();
        return defaultRectangle;
    }

    public static Rectangle createZero() {
        Rectangle rectangle = new Rectangle();
        rectangle.makeZeroRectangle();
        return rectangle;
    }

    public Rectangle merge(Rectangle that) {
        return new Rectangle(Integer.min(this.getMinPoint().x, that.getMinPoint().x), Integer.min(this.getMinPoint().y, that.getMinPoint().y), Integer.max(this.getMaxPoint().x, that.getMaxPoint().x), Integer.max(this.getMaxPoint().y, that.getMaxPoint().y));
    }

    public boolean isOverlapping(Rectangle that) {
        if (this.getMaxPoint().getY() < that.getMinPoint().getY() || that.getMaxPoint().getY() < this.getMinPoint().getY()) {
            return false;
        }
        return this.getMaxPoint().getX() >= that.getMinPoint().getX() && that.getMaxPoint().getX() >= this.getMinPoint().getX();
    }

    public void setDefaultValues() {
        this.maxPoint = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.minPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void makeZeroRectangle() {
        this.minPoint = new Point();
        this.maxPoint = new Point();
    }

    public Integer size() {
        return this.getWidth() * this.getHeight();
    }

    public int getWidth() {
        return this.maxPoint.x - this.minPoint.x + 1;
    }

    public int getHeight() {
        return this.maxPoint.y - this.minPoint.y + 1;
    }

    boolean containsPoint(Point point) {
        return point.x >= this.minPoint.x && point.x <= this.maxPoint.x && point.y >= this.minPoint.y && point.y <= this.maxPoint.y;
    }

    public Point getMinPoint() {
        return this.minPoint;
    }

    public void setMinPoint(Point minPoint) {
        this.minPoint = minPoint;
    }

    public Point getMaxPoint() {
        return this.maxPoint;
    }

    public void setMaxPoint(Point maxPoint) {
        this.maxPoint = maxPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        return this.minPoint.equals(rectangle.minPoint) && this.maxPoint.equals(rectangle.maxPoint);
    }

    public int hashCode() {
        return Objects.hash(this.minPoint, this.maxPoint);
    }
}

