/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.util.ArrayList;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.ImportJQueryUI;
import org.got5.tapestry5.jquery.base.AbstractExtendableComponent;
import org.got5.tapestry5.jquery.utils.JQueryAccordionData;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@SupportsInformalParameters
@ImportJQueryUI(value={"jquery.ui.core", "jquery.ui.widget", "jquery.ui.accordion"})
@Import(library={"${assets.path}/components/accordion/accordion.js"})
public class Accordion
extends AbstractExtendableComponent {
    @Parameter(defaultPrefix="literal")
    private String panels;
    @Parameter(required=true)
    private int activeElementId;
    @Parameter
    private JSONObject params;
    @Parameter(value="this", allowNull=false)
    @Property(write=false)
    private PropertyOverrides overrides;
    @Property
    @Parameter
    private ArrayList<JQueryAccordionData> listOfElements;
    @Property
    private JQueryAccordionData currentElement;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Property
    private String panel;

    @BeginRender
    void initJs() {
        this.setDefaultMethod("accordion");
    }

    @SetupRender
    void startDiv(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        this.resources.renderInformalParameters(writer);
        writer.end();
        JSONObject data = new JSONObject();
        data.put("id", (Object)this.getClientId());
        if (this.params == null) {
            this.params = new JSONObject();
        }
        JSONObject defaults = new JSONObject();
        defaults.put("active", (Object)this.activeElementId);
        JQueryUtils.merge(defaults, this.params);
        data.put("params", (Object)defaults);
        this.javaScriptSupport.addInitializerCall(this.getInitMethod(), data);
    }

    public Block getCurrentBlock() {
        if (this.resources.isBound("listOfElements")) {
            return this.resources.getContainer().getComponentResources().getBlock(this.currentElement.getBlockName());
        }
        return this.overrides.getOverrideBlock(this.panel);
    }

    public String[] getPanels() {
        return TapestryInternalUtils.splitAtCommas((String)this.panels);
    }

    public String getPanelTitle() {
        if (this.overrides.getOverrideMessages().contains(this.panel)) {
            return this.overrides.getOverrideMessages().get(this.panel);
        }
        return TapestryInternalUtils.toUserPresentable((String)this.panel);
    }

    public Boolean getJQueryAccordionData() {
        return this.resources.isBound("listOfElements");
    }
}

