/*
 * Copyright 2019 liaochong
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.constant.Constants;
import com.github.liaochong.myexcel.core.context.ReadContext;

import java.util.Objects;

/**
 * 布尔转换器
 *
 * @author liaochong
 * @version 1.0
 */
public class BoolReadConverter extends AbstractReadConverter<Boolean> {

    @Override
    public Boolean doConvert(ReadContext<?> readContext) {
        if (Objects.equals(Constants.ONE, readContext.getVal()) || readContext.getVal().equalsIgnoreCase(Constants.TRUE)) {
            return Boolean.TRUE;
        }
        if (Objects.equals(Constants.ZERO, readContext.getVal()) || readContext.getVal().equalsIgnoreCase(Constants.FALSE)) {
            return Boolean.FALSE;
        }
        throw new IllegalStateException("Cell content does not match the type of field to be injected,field is " + readContext.getField().getName() + ",value is \"" + readContext.getVal() + "\"");
    }
}
