/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jnr.ffi.Library;
import jnr.ffi.Platform;
import jnr.ffi.provider.jffi.SymbolNotFoundError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibrary {
    private final String[] libraryNames;
    private volatile List<com.kenai.jffi.Library> nativeLibraries = Collections.EMPTY_LIST;

    NativeLibrary(String name) {
        this.libraryNames = new String[]{name};
    }

    NativeLibrary(String ... names) {
        this.libraryNames = (String[])names.clone();
    }

    public static String locateLibrary(String libraryName) {
        if (new File(libraryName).isAbsolute()) {
            return libraryName;
        }
        LinkedList<String> searchPath = new LinkedList<String>();
        searchPath.addAll(0, Library.getLibraryPath(libraryName));
        searchPath.addAll(StaticDataHolder.userLibraryPath);
        String path = Platform.getNativePlatform().locateLibrary(libraryName, searchPath);
        return path != null ? path : null;
    }

    private static final List<String> getPropertyPaths(String propName) {
        String value = System.getProperty(propName);
        if (value != null) {
            String[] paths = value.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(paths));
        }
        return Collections.emptyList();
    }

    long getSymbolAddress(String name) {
        for (com.kenai.jffi.Library l : this.getNativeLibraries()) {
            long address = l.getSymbolAddress(name);
            if (address == 0L) continue;
            return address;
        }
        return 0L;
    }

    long findSymbolAddress(String name) {
        long address = this.getSymbolAddress(name);
        if (address == 0L) {
            throw new SymbolNotFoundError(com.kenai.jffi.Library.getLastError());
        }
        return address;
    }

    private synchronized List<com.kenai.jffi.Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<com.kenai.jffi.Library> loadNativeLibraries() {
        ArrayList<com.kenai.jffi.Library> libs = new ArrayList<com.kenai.jffi.Library>();
        for (String libraryName : this.libraryNames) {
            String path;
            com.kenai.jffi.Library lib = com.kenai.jffi.Library.getCachedInstance((String)libraryName, (int)9);
            if (lib == null && libraryName != null && (path = NativeLibrary.locateLibrary(libraryName)) != null && !libraryName.equals(path)) {
                lib = com.kenai.jffi.Library.getCachedInstance((String)path, (int)9);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            libs.add(lib);
        }
        return Collections.unmodifiableList(libs);
    }

    private static final class StaticDataHolder {
        private static final List<String> userLibraryPath = new CopyOnWriteArrayList<String>();

        private StaticDataHolder() {
        }

        static {
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jnr.ffi.library.path"));
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jaffl.library.path"));
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jna.library.path"));
        }
    }
}

