/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Stream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.data.vector.Vector;

class VectorImpl<T>
implements Vector<T> {
    private String name;
    private DataType type;
    private Measure measure;
    private T[] vector;

    public VectorImpl(String name, Class clazz, T[] vector) {
        this.name = name;
        this.type = DataTypes.object(clazz);
        this.measure = null;
        this.vector = vector;
    }

    public VectorImpl(String name, DataType type, T[] vector) {
        this.name = name;
        this.type = type;
        this.measure = null;
        this.vector = vector;
    }

    public VectorImpl(StructField field, T[] vector) {
        if (field.measure != null && (field.type.isIntegral() && field.measure instanceof NumericalMeasure || field.type.isFloating() && field.measure instanceof CategoricalMeasure || !field.type.isIntegral() && !field.type.isFloating())) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.type = field.type;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DataType type() {
        return this.type;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public Object array() {
        return this.vector;
    }

    @Override
    public T get(int i) {
        return this.vector[i];
    }

    @Override
    public Vector<T> get(int ... index) {
        Object[] v = (Object[])Array.newInstance(this.vector.getClass().getComponentType(), index.length);
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new VectorImpl<Object>(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public Stream<T> stream() {
        return Arrays.stream(this.vector);
    }

    public String toString() {
        return this.toString(10);
    }

    @Override
    public T[] toArray() {
        return this.vector;
    }

    @Override
    public double[] toDoubleArray() {
        if (!this.type.isNumeric()) {
            throw new UnsupportedOperationException(this.name() + ":" + this.type());
        }
        return this.stream().mapToDouble(d -> d == null ? Double.NaN : ((Number)d).doubleValue()).toArray();
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        if (!this.type.isNumeric()) {
            throw new UnsupportedOperationException(this.name() + ":" + this.type());
        }
        for (int i = 0; i < this.vector.length; ++i) {
            Number n = (Number)this.vector[i];
            a[i] = n == null ? Double.NaN : n.doubleValue();
        }
        return a;
    }

    @Override
    public int[] toIntArray() {
        if (!this.type.isIntegral()) {
            throw new UnsupportedOperationException(this.name() + ":" + this.type());
        }
        return this.stream().mapToInt(d -> d == null ? Integer.MIN_VALUE : ((Number)d).intValue()).toArray();
    }

    @Override
    public int[] toIntArray(int[] a) {
        if (!this.type.isIntegral()) {
            throw new UnsupportedOperationException(this.name() + ":" + this.type());
        }
        for (int i = 0; i < this.vector.length; ++i) {
            Number n = (Number)this.vector[i];
            a[i] = n == null ? Integer.MIN_VALUE : n.intValue();
        }
        return a;
    }

    @Override
    public Vector<LocalDate> toDate() {
        LocalDate[] dates = null;
        if (this.type.id() == DataType.ID.DateTime) {
            dates = (LocalDate[])this.stream().map(d -> ((LocalDateTime)d).toLocalDate()).toArray(LocalDate[]::new);
        } else if (this.type.id() == DataType.ID.Object) {
            Class clazz = ((ObjectType)this.type).getObjectClass();
            if (clazz == Date.class) {
                dates = (LocalDate[])this.stream().map(d -> ((Date)d).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).toArray(LocalDate[]::new);
            } else if (clazz == Instant.class) {
                dates = (LocalDate[])this.stream().map(d -> ((Instant)d).atZone(ZoneId.systemDefault()).toLocalDate()).toArray(LocalDate[]::new);
            }
        }
        if (dates == null) {
            throw new UnsupportedOperationException("Unsupported data type for toDate(): " + this.type);
        }
        return new VectorImpl<LocalDate>(this.name, DataTypes.DateType, dates);
    }

    @Override
    public Vector<LocalTime> toTime() {
        LocalTime[] dates = null;
        if (this.type.id() == DataType.ID.DateTime) {
            dates = (LocalTime[])this.stream().map(d -> ((LocalDateTime)d).toLocalTime()).toArray(LocalTime[]::new);
        } else if (this.type.id() == DataType.ID.Object) {
            Class clazz = ((ObjectType)this.type).getObjectClass();
            if (clazz == Date.class) {
                dates = (LocalTime[])this.stream().map(d -> ((Date)d).toInstant().atZone(ZoneId.systemDefault()).toLocalTime()).toArray(LocalTime[]::new);
            } else if (clazz == Instant.class) {
                dates = (LocalTime[])this.stream().map(d -> ((Instant)d).atZone(ZoneId.systemDefault()).toLocalTime()).toArray(LocalTime[]::new);
            }
        }
        if (dates == null) {
            throw new UnsupportedOperationException("Unsupported data type for toTime(): " + this.type);
        }
        return new VectorImpl<LocalTime>(this.name, DataTypes.TimeType, dates);
    }

    @Override
    public Vector<LocalDateTime> toDateTime() {
        LocalDateTime[] dates = null;
        if (this.type.id() == DataType.ID.Object) {
            Class clazz = ((ObjectType)this.type).getObjectClass();
            if (clazz == Date.class) {
                dates = (LocalDateTime[])this.stream().map(d -> ((Date)d).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).toArray(LocalDateTime[]::new);
            } else if (clazz == Instant.class) {
                dates = (LocalDateTime[])this.stream().map(d -> ((Instant)d).atZone(ZoneId.systemDefault()).toLocalDateTime()).toArray(LocalDateTime[]::new);
            }
        }
        if (dates != null) {
            throw new UnsupportedOperationException("Unsupported data type for toDateTime(): " + this.type);
        }
        return new VectorImpl<LocalDateTime>(this.name, DataTypes.DateTimeType, dates);
    }
}

