/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.AbstractTuple;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Delete;
import smile.data.formula.Dot;
import smile.data.formula.FactorCrossing;
import smile.data.formula.Feature;
import smile.data.formula.Intercept;
import smile.data.formula.Term;
import smile.data.formula.Variable;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.math.matrix.Matrix;

public class Formula
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(Formula.class);
    private Term response;
    private Term[] predictors;
    private transient Binding binding;

    public Formula(Term response, Term ... predictors) {
        if (response instanceof Dot || response instanceof FactorCrossing) {
            throw new IllegalArgumentException("The response variable cannot be '.' or FactorCrossing.");
        }
        this.response = response;
        this.predictors = predictors;
    }

    public Term[] predictors() {
        return this.predictors;
    }

    public Term response() {
        return this.response;
    }

    public String toString() {
        String r = this.response == null ? "" : this.response.toString();
        String p = Arrays.stream(this.predictors).map(predictor -> {
            String s = predictor.toString();
            if (!s.startsWith("- ")) {
                s = "+ " + s;
            }
            return s;
        }).collect(Collectors.joining(" "));
        if (p.startsWith("+ ")) {
            p = p.substring(2);
        }
        return String.format("%s ~ %s", r, p);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Formula)) {
            return false;
        }
        Formula f = (Formula)o;
        if (this.predictors.length != f.predictors.length) {
            return false;
        }
        if (!String.valueOf(this.response).equals(String.valueOf(f.response))) {
            return false;
        }
        for (int i = 0; i < this.predictors.length; ++i) {
            if (String.valueOf(this.predictors[i]).equals(String.valueOf(f.predictors[i]))) continue;
            return false;
        }
        return true;
    }

    public static Formula lhs(String lhs) {
        return Formula.lhs(new Variable(lhs));
    }

    public static Formula lhs(Term lhs) {
        return new Formula(lhs, new Dot());
    }

    public static Formula rhs(String ... predictors) {
        return Formula.of(null, predictors);
    }

    public static Formula rhs(Term ... predictors) {
        return new Formula(null, predictors);
    }

    public static Formula of(String response, String ... predictors) {
        return new Formula(new Variable(response), (Term[])Arrays.stream(predictors).map(predictor -> {
            if (predictor.equals(".")) {
                return new Dot();
            }
            if (predictor.equals("1")) {
                return new Intercept(true);
            }
            if (predictor.equals("0")) {
                return new Intercept(false);
            }
            return new Variable((String)predictor);
        }).toArray(Term[]::new));
    }

    public static Formula of(String response, Term ... predictors) {
        return new Formula(new Variable(response), predictors);
    }

    public static Formula of(Term response, Term ... predictors) {
        return new Formula(response, predictors);
    }

    public Formula expand(StructType inputSchema) {
        HashSet<String> columns = new HashSet<String>();
        if (this.response != null) {
            columns.addAll(this.response.variables());
        }
        Arrays.stream(this.predictors).filter(term -> term instanceof FactorCrossing || term instanceof Variable).forEach(term -> columns.addAll(term.variables()));
        List rest = Arrays.stream(inputSchema.fields()).filter(field -> !columns.contains(field.name)).map(field -> new Variable(field.name)).collect(Collectors.toList());
        ArrayList<Object> expanded = new ArrayList<Object>();
        for (Term predictor2 : this.predictors) {
            if (predictor2 instanceof Dot) {
                expanded.addAll(rest);
                continue;
            }
            if (predictor2 instanceof Delete) continue;
            expanded.addAll(predictor2.expand());
        }
        Set deletes = Arrays.stream(this.predictors).filter(predictor -> predictor instanceof Delete).flatMap(predictor -> predictor.expand().stream()).map(term -> term.toString().substring(2)).collect(Collectors.toSet());
        expanded.removeIf(term -> deletes.contains(term.toString()));
        return new Formula(this.response, expanded.toArray(new Term[expanded.size()]));
    }

    public StructType bind(StructType inputSchema) {
        if (this.binding != null && this.binding.inputSchema == inputSchema) {
            return this.binding.xschema;
        }
        Formula formula = this.expand(inputSchema);
        this.binding = new Binding();
        this.binding.inputSchema = inputSchema;
        List<Feature> features = Arrays.stream(formula.predictors).filter(predictor -> !(predictor instanceof Delete) && !(predictor instanceof Intercept)).flatMap(predictor -> predictor.bind(inputSchema).stream()).collect(Collectors.toList());
        this.binding.x = features.toArray(new Feature[features.size()]);
        this.binding.xschema = DataTypes.struct((StructField[])features.stream().map(term -> term.field()).toArray(StructField[]::new));
        if (this.response != null) {
            try {
                features.addAll(0, this.response.bind(inputSchema));
                this.binding.yx = features.toArray(new Feature[features.size()]);
                this.binding.yxschema = DataTypes.struct((StructField[])features.stream().map(term -> term.field()).toArray(StructField[]::new));
            }
            catch (NullPointerException ex) {
                logger.debug("The response variable {} doesn't exist in the schema {}", (Object)this.response, (Object)inputSchema);
            }
        }
        return this.binding.xschema;
    }

    public Tuple apply(final Tuple t) {
        this.bind(t.schema());
        return new AbstractTuple(){

            @Override
            public StructType schema() {
                return ((Formula)Formula.this).binding.yxschema;
            }

            @Override
            public Object get(int i) {
                return ((Formula)Formula.this).binding.yx[i].apply(t);
            }

            @Override
            public int getInt(int i) {
                return ((Formula)Formula.this).binding.yx[i].applyAsInt(t);
            }

            @Override
            public long getLong(int i) {
                return ((Formula)Formula.this).binding.yx[i].applyAsLong(t);
            }

            @Override
            public float getFloat(int i) {
                return ((Formula)Formula.this).binding.yx[i].applyAsFloat(t);
            }

            @Override
            public double getDouble(int i) {
                return ((Formula)Formula.this).binding.yx[i].applyAsDouble(t);
            }

            @Override
            public String toString() {
                return ((Formula)Formula.this).binding.yxschema.toString(this);
            }
        };
    }

    public Tuple x(final Tuple t) {
        this.bind(t.schema());
        return new AbstractTuple(){

            @Override
            public StructType schema() {
                return ((Formula)Formula.this).binding.xschema;
            }

            @Override
            public Object get(int i) {
                return ((Formula)Formula.this).binding.x[i].apply(t);
            }

            @Override
            public int getInt(int i) {
                return ((Formula)Formula.this).binding.x[i].applyAsInt(t);
            }

            @Override
            public long getLong(int i) {
                return ((Formula)Formula.this).binding.x[i].applyAsLong(t);
            }

            @Override
            public float getFloat(int i) {
                return ((Formula)Formula.this).binding.x[i].applyAsFloat(t);
            }

            @Override
            public double getDouble(int i) {
                return ((Formula)Formula.this).binding.x[i].applyAsDouble(t);
            }

            @Override
            public String toString() {
                return ((Formula)Formula.this).binding.xschema.toString(this);
            }
        };
    }

    public DataFrame frame(DataFrame df) {
        this.bind(df.schema());
        BaseVector[] vectors = (BaseVector[])Arrays.stream(this.binding.yx != null ? this.binding.yx : this.binding.x).map(term -> term.apply(df)).toArray(BaseVector[]::new);
        return DataFrame.of(vectors);
    }

    public DataFrame x(DataFrame df) {
        this.bind(df.schema());
        BaseVector[] vectors = (BaseVector[])Arrays.stream(this.binding.x).map(term -> term.apply(df)).toArray(BaseVector[]::new);
        return DataFrame.of(vectors);
    }

    public Matrix matrix(DataFrame df) {
        boolean bias = true;
        Optional<Intercept> intercept = Arrays.stream(this.predictors).filter(term -> term instanceof Intercept).map(term -> (Intercept)term).findAny();
        if (intercept.isPresent()) {
            bias = intercept.get().bias();
        }
        return this.matrix(df, bias);
    }

    public Matrix matrix(DataFrame df, boolean bias) {
        return this.x(df).toMatrix(bias, CategoricalEncoder.DUMMY, null);
    }

    public BaseVector y(DataFrame df) {
        if (this.response == null) {
            throw new UnsupportedOperationException("The formula has no response variable.");
        }
        this.bind(df.schema());
        if (this.binding.yx == null) {
            throw new UnsupportedOperationException("The data has no response variable.");
        }
        return this.binding.yx[0].apply(df);
    }

    public double y(Tuple t) {
        if (this.response == null) {
            throw new UnsupportedOperationException("The formula has no response variable.");
        }
        this.bind(t.schema());
        if (this.binding.yx == null) {
            throw new UnsupportedOperationException("The data has no response variable.");
        }
        return this.binding.yx[0].applyAsDouble(t);
    }

    public int yint(Tuple t) {
        if (this.response == null) {
            throw new UnsupportedOperationException("The formula has no response variable.");
        }
        this.bind(t.schema());
        if (this.binding.yx == null) {
            throw new UnsupportedOperationException("The data has no response variable.");
        }
        return this.binding.yx[0].applyAsInt(t);
    }

    private class Binding {
        StructType inputSchema;
        StructType yxschema;
        StructType xschema;
        Feature[] yx;
        Feature[] x;

        private Binding() {
        }
    }
}

