/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.IntStream;
import smile.data.type.StructField;
import smile.data.vector.CharVector;

class CharVectorImpl
implements CharVector {
    private String name;
    private char[] vector;

    public CharVectorImpl(String name, char[] vector) {
        this.name = name;
        this.vector = vector;
    }

    public CharVectorImpl(StructField field, char[] vector) {
        if (field.measure != null) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public char[] array() {
        return this.vector;
    }

    @Override
    public int[] toIntArray(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public char getChar(int i) {
        return this.vector[i];
    }

    @Override
    public Character get(int i) {
        return Character.valueOf(this.vector[i]);
    }

    public CharVector get(int ... index) {
        char[] v = new char[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new CharVectorImpl(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.vector.length).map(i -> this.vector[i]);
    }

    public String toString() {
        return this.toString(10);
    }
}

