/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.IntStream;
import smile.data.measure.Measure;
import smile.data.measure.NumericalMeasure;
import smile.data.type.StructField;
import smile.data.vector.ByteVector;

class ByteVectorImpl
implements ByteVector {
    private String name;
    private Measure measure;
    private byte[] vector;

    public ByteVectorImpl(String name, byte[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public ByteVectorImpl(StructField field, byte[] vector) {
        if (field.measure instanceof NumericalMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public byte[] array() {
        return this.vector;
    }

    @Override
    public int[] toIntArray(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public byte getByte(int i) {
        return this.vector[i];
    }

    @Override
    public Byte get(int i) {
        return this.vector[i];
    }

    public ByteVector get(int ... index) {
        byte[] v = new byte[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new ByteVectorImpl(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.vector.length).map(i -> this.vector[i]);
    }

    public String toString() {
        return this.toString(10);
    }
}

