/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.formula.FactorInteraction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.formula.Variable;
import smile.data.type.StructType;

class FactorCrossing
implements Term {
    private int order;
    private List<String> factors;
    private List<Term> terms;

    @SafeVarargs
    public FactorCrossing(String ... factors) {
        this(factors.length, factors);
    }

    @SafeVarargs
    public FactorCrossing(int order, String ... factors) {
        if (factors.length < 2) {
            throw new IllegalArgumentException("FactorCrossing takes at least two factors");
        }
        if (order < 2 || order > factors.length) {
            throw new IllegalArgumentException("Invalid order of interactions: " + order);
        }
        this.order = order;
        this.factors = Arrays.asList(factors);
        this.terms = new ArrayList<Term>();
        String[] work = new String[order];
        FactorCrossing.combination(this.terms, factors, work, order, 0, factors.length - 1, 0);
        Comparator compareBySize = (o1, o2) -> {
            int n1 = o1 instanceof FactorInteraction ? ((FactorInteraction)o1).size() : 1;
            int n2 = o2 instanceof FactorInteraction ? ((FactorInteraction)o2).size() : 1;
            return n1 - n2;
        };
        Collections.sort(this.terms, compareBySize);
    }

    private static void combination(List<Term> terms, String[] factors, String[] data, int order, int start, int end, int index) {
        if (index == order) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            data[index] = factors[i];
            if (index == 0) {
                terms.add(new Variable(data[index]));
            } else {
                terms.add(new FactorInteraction(Arrays.copyOf(data, index + 1)));
            }
            FactorCrossing.combination(terms, factors, data, order, i + 1, end, index + 1);
        }
    }

    public String toString() {
        if (this.order < this.factors.size()) {
            return this.factors.stream().collect(Collectors.joining(" x ", "(", ")^" + this.order));
        }
        return this.factors.stream().collect(Collectors.joining(" x ", "(", ")"));
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(this.factors);
    }

    @Override
    public List<Term> expand() {
        return this.terms;
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Term term : this.terms) {
            features.addAll(term.bind(schema));
        }
        return features;
    }
}

