/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.IntStream;
import smile.data.type.StructField;
import smile.data.vector.BooleanVector;

class BooleanVectorImpl
implements BooleanVector {
    private String name;
    private boolean[] vector;

    public BooleanVectorImpl(String name, boolean[] vector) {
        this.name = name;
        this.vector = vector;
    }

    public BooleanVectorImpl(StructField field, boolean[] vector) {
        if (field.measure != null) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean[] array() {
        return this.vector;
    }

    @Override
    public int[] toIntArray(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i] ? 1 : 0;
        }
        return a;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i] ? 1.0 : 0.0;
        }
        return a;
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i];
    }

    @Override
    public Boolean get(int i) {
        return this.vector[i];
    }

    public BooleanVector get(int ... index) {
        boolean[] v = new boolean[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new BooleanVectorImpl(this.name, v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.vector.length).map(i -> this.vector[i] ? 1 : 0);
    }

    public String toString() {
        return this.toString(10);
    }
}

