/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;

class Round
extends AbstractFunction {
    public Round(Term x) {
        super("round", x);
    }

    @Override
    public DataType type() {
        if (this.x.type().equals(DataTypes.DoubleType)) {
            return DataTypes.LongType;
        }
        if (this.x.type().equals(DataTypes.FloatType)) {
            return DataTypes.IntegerType;
        }
        if (this.x.type().equals(DataTypes.object(Double.class))) {
            return DataTypes.object(Long.class);
        }
        return DataTypes.object(Integer.class);
    }

    @Override
    public void bind(StructType schema) {
        this.x.bind(schema);
        if (!this.x.type().isDouble() && !this.x.type().isFloat()) {
            throw new IllegalStateException(String.format("Invalid expression: round(%s)", this.x.type()));
        }
    }

    @Override
    public double applyAsDouble(Tuple o) {
        return Math.round(this.x.applyAsDouble(o));
    }

    @Override
    public Long apply(Tuple o) {
        Object y = this.x.apply(o);
        if (y == null) {
            return null;
        }
        return Math.round(((Number)y).doubleValue());
    }
}

