/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.formula.HyperTerm;
import smile.data.formula.OneHotEncoder;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.StructType;

class OneHot
implements HyperTerm {
    private String[] variables;
    private List<OneHotEncoder> terms;

    public OneHot(String ... variables) {
        this.variables = variables;
    }

    public String toString() {
        if (this.variables == null || this.variables.length == 0) {
            return "one-hot";
        }
        return String.format("one-hot(%s)", Arrays.stream(this.variables).collect(Collectors.joining(", ")));
    }

    public List<OneHotEncoder> terms() {
        return this.terms;
    }

    @Override
    public Set<String> variables() {
        if (this.variables == null || this.variables.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String column : this.variables) {
            set.add(column);
        }
        return set;
    }

    @Override
    public void bind(StructType schema) {
        if (this.variables == null || this.variables.length == 0) {
            this.variables = (String[])Arrays.stream(schema.fields()).filter(field -> field.measure instanceof NominalScale).map(field -> field.name).toArray(String[]::new);
        }
        this.terms = new ArrayList<OneHotEncoder>();
        for (String name : this.variables) {
            int column = schema.fieldIndex(name);
            Measure measure = schema.field((int)column).measure;
            if (!(measure instanceof NominalScale)) {
                throw new UnsupportedOperationException(String.format("The variable %s is not of nominal", name));
            }
            NominalScale scale = (NominalScale)measure;
            for (int value : scale.values()) {
                this.terms.add(new OneHotEncoder(name, column, value, scale.level(value)));
            }
        }
    }
}

