/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;

public class IntFunction
extends AbstractFunction {
    private smile.math.IntFunction lambda;

    public IntFunction(String name, Term x, smile.math.IntFunction lambda) {
        super(name, x);
        this.lambda = lambda;
    }

    @Override
    public DataType type() {
        return this.x.type().id() == DataType.ID.Object ? DataTypes.IntegerObjectType : DataTypes.IntegerType;
    }

    @Override
    public void bind(StructType schema) {
        this.x.bind(schema);
        if (!(this.x.type().isInt() || this.x.type().isShort() || this.x.type().isLong())) {
            throw new IllegalStateException(String.format("Invalid expression: %s(%s)", this.name, this.x.type()));
        }
    }

    @Override
    public int applyAsInt(Tuple o) {
        return this.lambda.apply(this.x.applyAsInt(o));
    }

    @Override
    public Integer apply(Tuple o) {
        Object y = this.x.apply(o);
        if (y == null) {
            return null;
        }
        return this.lambda.apply(((Number)y).intValue());
    }
}

