/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.Tuple;
import smile.data.formula.AbstractTerm;
import smile.data.formula.DateFeature;
import smile.data.formula.HyperTerm;
import smile.data.formula.Term;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;

class Date
implements HyperTerm {
    private final String name;
    private final DateFeature[] features;
    private List<FeatureExtractor> terms;
    private DataType type;
    private int index = -1;

    public Date(String name, DateFeature ... features) {
        this.name = name;
        this.features = features;
        this.terms = Arrays.stream(features).map(feature -> new FeatureExtractor((DateFeature)((Object)feature))).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("%s%s", this.name, Arrays.toString((Object[])this.features));
    }

    @Override
    public List<? extends Term> terms() {
        return this.terms;
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public void bind(StructType schema) {
        this.index = schema.fieldIndex(this.name);
        this.type = schema.field((String)this.name).type;
        switch (this.type.id()) {
            case Date: {
                if (!this.hasTimeFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract time features from a date.");
            }
            case Time: {
                if (!this.hasDateFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract date features from a time.");
            }
            case DateTime: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The filed %s is not a date/time: %s", this.name, this.type));
            }
        }
    }

    private boolean hasTimeFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case HOURS: 
                case MINUTES: 
                case SECONDS: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasDateFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case YEAR: 
                case MONTH: 
                case DAY_OF_MONTH: 
                case DAY_OF_WEEK: {
                    return true;
                }
            }
        }
        return false;
    }

    class FeatureExtractor
    extends AbstractTerm {
        DateFeature feature;
        Optional<Measure> measure;

        public FeatureExtractor(DateFeature feature) {
            this.feature = feature;
            switch (feature) {
                case MONTH: {
                    int[] values = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
                    String[] levels = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
                    this.measure = Optional.of(new NominalScale(values, levels));
                    break;
                }
                case DAY_OF_WEEK: {
                    int[] values = new int[]{1, 2, 3, 4, 5, 6, 7};
                    String[] levels = new String[]{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};
                    this.measure = Optional.of(new NominalScale(values, levels));
                    break;
                }
                default: {
                    this.measure = Optional.empty();
                }
            }
        }

        public String toString() {
            return this.name();
        }

        @Override
        public Set<String> variables() {
            return Collections.singleton(Date.this.name);
        }

        @Override
        public int applyAsInt(Tuple o) {
            Object x = this.apply(o);
            return x == null ? -1 : (Integer)x;
        }

        @Override
        public Object apply(Tuple o) {
            Object x = o.get(Date.this.index);
            if (x == null) {
                return null;
            }
            switch (Date.this.type.id()) {
                case Date: {
                    LocalDate date = (LocalDate)x;
                    switch (this.feature) {
                        case YEAR: {
                            return date.getYear();
                        }
                        case MONTH: {
                            return date.getMonthValue();
                        }
                        case DAY_OF_MONTH: {
                            return date.getDayOfMonth();
                        }
                        case DAY_OF_WEEK: {
                            return date.getDayOfWeek().getValue();
                        }
                    }
                    throw new IllegalStateException("Extra time features from a date.");
                }
                case Time: {
                    LocalTime time = (LocalTime)x;
                    switch (this.feature) {
                        case HOURS: {
                            return time.getHour();
                        }
                        case MINUTES: {
                            return time.getMinute();
                        }
                        case SECONDS: {
                            return time.getSecond();
                        }
                    }
                    throw new IllegalStateException("Extra date features from a time.");
                }
                case DateTime: {
                    LocalDateTime dateTime = (LocalDateTime)x;
                    switch (this.feature) {
                        case YEAR: {
                            return dateTime.getYear();
                        }
                        case MONTH: {
                            return dateTime.getMonthValue();
                        }
                        case DAY_OF_MONTH: {
                            return dateTime.getDayOfMonth();
                        }
                        case DAY_OF_WEEK: {
                            return dateTime.getDayOfWeek().getValue();
                        }
                        case HOURS: {
                            return dateTime.getHour();
                        }
                        case MINUTES: {
                            return dateTime.getMinute();
                        }
                        case SECONDS: {
                            return dateTime.getSecond();
                        }
                    }
                    break;
                }
            }
            throw new IllegalStateException("Unsupported data type for date/time features");
        }

        @Override
        public String name() {
            return String.format("%s_%s", new Object[]{Date.this.name, this.feature});
        }

        @Override
        public DataType type() {
            return DataTypes.IntegerType;
        }

        @Override
        public Optional<Measure> measure() {
            return this.measure;
        }

        @Override
        public void bind(StructType schema) {
        }
    }
}

