
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * A single entry from an ontology or a controlled vocabulary.
 *
 * <p>Java class for CVParamType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CVParamType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psidev.info/psi/pi/mzIdentML/1.2}AbstractParamType">
 *       &lt;attribute name="cvRef" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="accession" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CVParamType")
public class CVParamType
    extends AbstractParamType {

  @XmlAttribute(name = "cvRef", required = true)
  protected String cvRef;
  @XmlAttribute(name = "accession", required = true)
  protected String accession;

  /**
   * Gets the value of the cvRef property.
   *
   * @return possible object is {@link String }
   */
  public String getCvRef() {
    return cvRef;
  }

  /**
   * Sets the value of the cvRef property.
   *
   * @param value allowed object is {@link String }
   */
  public void setCvRef(String value) {
    this.cvRef = value;
  }

  /**
   * Gets the value of the accession property.
   *
   * @return possible object is {@link String }
   */
  public String getAccession() {
    return accession;
  }

  /**
   * Sets the value of the accession property.
   *
   * @param value allowed object is {@link String }
   */
  public void setAccession(String value) {
    this.accession = value;
  }

}
