
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each Java content interface and Java element interface
 * generated in the umich.ms.fileio.filetypes.mzidentml.jaxb.standard package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation for XML content. The Java representation of
 * XML content can consist of schema derived interfaces and classes representing the binding of
 * schema type definitions, element declarations and model groups.  Factory methods for each of
 * these are provided in this class.
 */
@XmlRegistry
public class ObjectFactory {

  private final static QName _MzIdentML_QNAME = new QName("http://psidev.info/psi/pi/mzIdentML/1.2",
      "MzIdentML");

  /**
   * Create a new ObjectFactory that can be used to create new instances of schema derived classes
   * for package: umich.ms.fileio.filetypes.mzidentml.jaxb.standard
   */
  public ObjectFactory() {
  }

  /**
   * Create an instance of {@link MzIdentMLType }
   */
  public MzIdentMLType createMzIdentMLType() {
    return new MzIdentMLType();
  }

  /**
   * Create an instance of {@link SpectrumIDFormatType }
   */
  public SpectrumIDFormatType createSpectrumIDFormatType() {
    return new SpectrumIDFormatType();
  }

  /**
   * Create an instance of {@link SearchDatabaseType }
   */
  public SearchDatabaseType createSearchDatabaseType() {
    return new SearchDatabaseType();
  }

  /**
   * Create an instance of {@link ParentOrganizationType }
   */
  public ParentOrganizationType createParentOrganizationType() {
    return new ParentOrganizationType();
  }

  /**
   * Create an instance of {@link RoleType }
   */
  public RoleType createRoleType() {
    return new RoleType();
  }

  /**
   * Create an instance of {@link PersonType }
   */
  public PersonType createPersonType() {
    return new PersonType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationItemRefType }
   */
  public SpectrumIdentificationItemRefType createSpectrumIdentificationItemRefType() {
    return new SpectrumIdentificationItemRefType();
  }

  /**
   * Create an instance of {@link AnalysisProtocolCollectionType }
   */
  public AnalysisProtocolCollectionType createAnalysisProtocolCollectionType() {
    return new AnalysisProtocolCollectionType();
  }

  /**
   * Create an instance of {@link AnalysisDataType }
   */
  public AnalysisDataType createAnalysisDataType() {
    return new AnalysisDataType();
  }

  /**
   * Create an instance of {@link DatabaseFiltersType }
   */
  public DatabaseFiltersType createDatabaseFiltersType() {
    return new DatabaseFiltersType();
  }

  /**
   * Create an instance of {@link FragmentationTableType }
   */
  public FragmentationTableType createFragmentationTableType() {
    return new FragmentationTableType();
  }

  /**
   * Create an instance of {@link FragmentArrayType }
   */
  public FragmentArrayType createFragmentArrayType() {
    return new FragmentArrayType();
  }

  /**
   * Create an instance of {@link DBSequenceType }
   */
  public DBSequenceType createDBSequenceType() {
    return new DBSequenceType();
  }

  /**
   * Create an instance of {@link PeptideEvidenceType }
   */
  public PeptideEvidenceType createPeptideEvidenceType() {
    return new PeptideEvidenceType();
  }

  /**
   * Create an instance of {@link ContactRoleType }
   */
  public ContactRoleType createContactRoleType() {
    return new ContactRoleType();
  }

  /**
   * Create an instance of {@link UserParamType }
   */
  public UserParamType createUserParamType() {
    return new UserParamType();
  }

  /**
   * Create an instance of {@link SourceFileType }
   */
  public SourceFileType createSourceFileType() {
    return new SourceFileType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationProtocolType }
   */
  public SpectrumIdentificationProtocolType createSpectrumIdentificationProtocolType() {
    return new SpectrumIdentificationProtocolType();
  }

  /**
   * Create an instance of {@link IonTypeType }
   */
  public IonTypeType createIonTypeType() {
    return new IonTypeType();
  }

  /**
   * Create an instance of {@link ToleranceType }
   */
  public ToleranceType createToleranceType() {
    return new ToleranceType();
  }

  /**
   * Create an instance of {@link ProteinDetectionProtocolType }
   */
  public ProteinDetectionProtocolType createProteinDetectionProtocolType() {
    return new ProteinDetectionProtocolType();
  }

  /**
   * Create an instance of {@link FileFormatType }
   */
  public FileFormatType createFileFormatType() {
    return new FileFormatType();
  }

  /**
   * Create an instance of {@link ParamListType }
   */
  public ParamListType createParamListType() {
    return new ParamListType();
  }

  /**
   * Create an instance of {@link InputSpectraType }
   */
  public InputSpectraType createInputSpectraType() {
    return new InputSpectraType();
  }

  /**
   * Create an instance of {@link TranslationTableType }
   */
  public TranslationTableType createTranslationTableType() {
    return new TranslationTableType();
  }

  /**
   * Create an instance of {@link MassTableType }
   */
  public MassTableType createMassTableType() {
    return new MassTableType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationItemType }
   */
  public SpectrumIdentificationItemType createSpectrumIdentificationItemType() {
    return new SpectrumIdentificationItemType();
  }

  /**
   * Create an instance of {@link ProteinDetectionType }
   */
  public ProteinDetectionType createProteinDetectionType() {
    return new ProteinDetectionType();
  }

  /**
   * Create an instance of {@link SubstitutionModificationType }
   */
  public SubstitutionModificationType createSubstitutionModificationType() {
    return new SubstitutionModificationType();
  }

  /**
   * Create an instance of {@link ParamType }
   */
  public ParamType createParamType() {
    return new ParamType();
  }

  /**
   * Create an instance of {@link FilterType }
   */
  public FilterType createFilterType() {
    return new FilterType();
  }

  /**
   * Create an instance of {@link SpecificityRulesType }
   */
  public SpecificityRulesType createSpecificityRulesType() {
    return new SpecificityRulesType();
  }

  /**
   * Create an instance of {@link PeptideHypothesisType }
   */
  public PeptideHypothesisType createPeptideHypothesisType() {
    return new PeptideHypothesisType();
  }

  /**
   * Create an instance of {@link SearchDatabaseRefType }
   */
  public SearchDatabaseRefType createSearchDatabaseRefType() {
    return new SearchDatabaseRefType();
  }

  /**
   * Create an instance of {@link EnzymeType }
   */
  public EnzymeType createEnzymeType() {
    return new EnzymeType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationType }
   */
  public SpectrumIdentificationType createSpectrumIdentificationType() {
    return new SpectrumIdentificationType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationListType }
   */
  public SpectrumIdentificationListType createSpectrumIdentificationListType() {
    return new SpectrumIdentificationListType();
  }

  /**
   * Create an instance of {@link ProviderType }
   */
  public ProviderType createProviderType() {
    return new ProviderType();
  }

  /**
   * Create an instance of {@link DatabaseTranslationType }
   */
  public DatabaseTranslationType createDatabaseTranslationType() {
    return new DatabaseTranslationType();
  }

  /**
   * Create an instance of {@link PeptideType }
   */
  public PeptideType createPeptideType() {
    return new PeptideType();
  }

  /**
   * Create an instance of {@link SpectrumIdentificationResultType }
   */
  public SpectrumIdentificationResultType createSpectrumIdentificationResultType() {
    return new SpectrumIdentificationResultType();
  }

  /**
   * Create an instance of {@link AmbiguousResidueType }
   */
  public AmbiguousResidueType createAmbiguousResidueType() {
    return new AmbiguousResidueType();
  }

  /**
   * Create an instance of {@link ProteinAmbiguityGroupType }
   */
  public ProteinAmbiguityGroupType createProteinAmbiguityGroupType() {
    return new ProteinAmbiguityGroupType();
  }

  /**
   * Create an instance of {@link MeasureType }
   */
  public MeasureType createMeasureType() {
    return new MeasureType();
  }

  /**
   * Create an instance of {@link AuditCollectionType }
   */
  public AuditCollectionType createAuditCollectionType() {
    return new AuditCollectionType();
  }

  /**
   * Create an instance of {@link DataCollectionType }
   */
  public DataCollectionType createDataCollectionType() {
    return new DataCollectionType();
  }

  /**
   * Create an instance of {@link AnalysisSampleCollectionType }
   */
  public AnalysisSampleCollectionType createAnalysisSampleCollectionType() {
    return new AnalysisSampleCollectionType();
  }

  /**
   * Create an instance of {@link AnalysisCollectionType }
   */
  public AnalysisCollectionType createAnalysisCollectionType() {
    return new AnalysisCollectionType();
  }

  /**
   * Create an instance of {@link CVListType }
   */
  public CVListType createCVListType() {
    return new CVListType();
  }

  /**
   * Create an instance of {@link InputSpectrumIdentificationsType }
   */
  public InputSpectrumIdentificationsType createInputSpectrumIdentificationsType() {
    return new InputSpectrumIdentificationsType();
  }

  /**
   * Create an instance of {@link ProteinDetectionListType }
   */
  public ProteinDetectionListType createProteinDetectionListType() {
    return new ProteinDetectionListType();
  }

  /**
   * Create an instance of {@link SubSampleType }
   */
  public SubSampleType createSubSampleType() {
    return new SubSampleType();
  }

  /**
   * Create an instance of {@link ModificationParamsType }
   */
  public ModificationParamsType createModificationParamsType() {
    return new ModificationParamsType();
  }

  /**
   * Create an instance of {@link BibliographicReferenceType }
   */
  public BibliographicReferenceType createBibliographicReferenceType() {
    return new BibliographicReferenceType();
  }

  /**
   * Create an instance of {@link CVParamType }
   */
  public CVParamType createCVParamType() {
    return new CVParamType();
  }

  /**
   * Create an instance of {@link CvType }
   */
  public CvType createCvType() {
    return new CvType();
  }

  /**
   * Create an instance of {@link SpectraDataType }
   */
  public SpectraDataType createSpectraDataType() {
    return new SpectraDataType();
  }

  /**
   * Create an instance of {@link AnalysisSoftwareType }
   */
  public AnalysisSoftwareType createAnalysisSoftwareType() {
    return new AnalysisSoftwareType();
  }

  /**
   * Create an instance of {@link ProteinDetectionHypothesisType }
   */
  public ProteinDetectionHypothesisType createProteinDetectionHypothesisType() {
    return new ProteinDetectionHypothesisType();
  }

  /**
   * Create an instance of {@link ExternalDataType }
   */
  public ExternalDataType createExternalDataType() {
    return new ExternalDataType();
  }

  /**
   * Create an instance of {@link AnalysisSoftwareListType }
   */
  public AnalysisSoftwareListType createAnalysisSoftwareListType() {
    return new AnalysisSoftwareListType();
  }

  /**
   * Create an instance of {@link ResidueType }
   */
  public ResidueType createResidueType() {
    return new ResidueType();
  }

  /**
   * Create an instance of {@link InputsType }
   */
  public InputsType createInputsType() {
    return new InputsType();
  }

  /**
   * Create an instance of {@link SearchModificationType }
   */
  public SearchModificationType createSearchModificationType() {
    return new SearchModificationType();
  }

  /**
   * Create an instance of {@link FragmentationType }
   */
  public FragmentationType createFragmentationType() {
    return new FragmentationType();
  }

  /**
   * Create an instance of {@link OrganizationType }
   */
  public OrganizationType createOrganizationType() {
    return new OrganizationType();
  }

  /**
   * Create an instance of {@link SequenceCollectionType }
   */
  public SequenceCollectionType createSequenceCollectionType() {
    return new SequenceCollectionType();
  }

  /**
   * Create an instance of {@link AffiliationType }
   */
  public AffiliationType createAffiliationType() {
    return new AffiliationType();
  }

  /**
   * Create an instance of {@link PeptideEvidenceRefType }
   */
  public PeptideEvidenceRefType createPeptideEvidenceRefType() {
    return new PeptideEvidenceRefType();
  }

  /**
   * Create an instance of {@link ModificationType }
   */
  public ModificationType createModificationType() {
    return new ModificationType();
  }

  /**
   * Create an instance of {@link EnzymesType }
   */
  public EnzymesType createEnzymesType() {
    return new EnzymesType();
  }

  /**
   * Create an instance of {@link SampleType }
   */
  public SampleType createSampleType() {
    return new SampleType();
  }

  /**
   * Create an instance of {@link JAXBElement }{@code <}{@link MzIdentMLType }{@code >}}
   */
  @XmlElementDecl(namespace = "http://psidev.info/psi/pi/mzIdentML/1.2", name = "MzIdentML")
  public JAXBElement<MzIdentMLType> createMzIdentML(MzIdentMLType value) {
    return new JAXBElement<MzIdentMLType>(_MzIdentML_QNAME, MzIdentMLType.class, null, value);
  }

}
