package com.franciaflex.magalie.persistence.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import org.nuiton.jpa.api.AbstractJpaEntity;
import org.nuiton.jpa.api.JpaEntities;
import org.nuiton.jpa.api.JpaEntityIdFactoryResolver;

@Generated(value = "org.nuiton.jpa.templates.JpaEntityTransformer", date = "Wed Sep 11 18:18:21 CEST 2013")
@MappedSuperclass
public abstract class AbstractJpaArticle extends AbstractJpaEntity implements Serializable {

    private static final long serialVersionUID = 7161904709017940788L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_DESCRIPTION = "description";

    public static final String PROPERTY_CODE = "code";

    public static final String PROPERTY_UNIT = "unit";

    public static final String PROPERTY_FIXED_LOCATIONS_FIRST = "fixedLocationsFirst";

    public static final String PROPERTY_DIRECT_WITHDRAW_ALLOWED = "directWithdrawAllowed";

    public static final String PROPERTY_FIXED_LOCATIONS = "fixedLocations";

    public static final String PROPERTY_SUPPLIER = "supplier";

    public static final String PROPERTY_COMPANY = "company";

    @Id
    protected String id;

    protected String description;

    protected String code;

    protected String unit;

    protected boolean fixedLocationsFirst;

    protected boolean directWithdrawAllowed;

    @ManyToMany
    protected Set<Location> fixedLocations;

    @ManyToOne
    protected Supplier supplier;

    @ManyToOne
    protected Company company;

    @PrePersist
    public void prePersist() {
        if (this.id == null) {
            this.id = new JpaEntityIdFactoryResolver().newId(this);
        }
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isFixedLocationsFirst() {
        return fixedLocationsFirst;
    }

    public void setFixedLocationsFirst(boolean fixedLocationsFirst) {
        this.fixedLocationsFirst = fixedLocationsFirst;
    }

    public boolean isDirectWithdrawAllowed() {
        return directWithdrawAllowed;
    }

    public void setDirectWithdrawAllowed(boolean directWithdrawAllowed) {
        this.directWithdrawAllowed = directWithdrawAllowed;
    }

    public Location getFixedLocations(int index) {
        Location o = getChild(fixedLocations, index);
        return o;
    }

    public Location getFixedLocationsById(String id) {
        Location o = JpaEntities.findById(fixedLocations, id);
        return o;
    }

    public boolean isFixedLocationsEmpty() {
        return fixedLocations == null || fixedLocations.isEmpty();
    }

    public int sizeFixedLocations() {
        return fixedLocations == null ? 0 : fixedLocations.size();
    }

    public void addFixedLocations(Location fixedLocations) {
        if (getFixedLocations() == null) {
            setFixedLocations(new HashSet<Location>());
        }
        getFixedLocations().add(fixedLocations);
    }

    public void addAllFixedLocations(Collection<Location> fixedLocations) {
        if (getFixedLocations() == null) {
            setFixedLocations(new HashSet<Location>());
        }
        getFixedLocations().addAll(fixedLocations);
    }

    public boolean removeFixedLocations(Location fixedLocations) {
        boolean removed = getFixedLocations() != null && getFixedLocations().remove(fixedLocations);
        return removed;
    }

    public boolean removeAllFixedLocations(Collection<Location> fixedLocations) {
        boolean  removed = getFixedLocations() != null && getFixedLocations().removeAll(fixedLocations);
        return removed;
    }

    public boolean containsFixedLocations(Location fixedLocations) {
        boolean contains = getFixedLocations() != null && getFixedLocations().contains(fixedLocations);
        return contains;
    }

    public boolean containsFixedLocationsById(String id) {
        boolean contains = getFixedLocations() != null && getFixedLocationsById(id) != null;
        return contains;
    }

    public boolean containsAllFixedLocations(Collection<Location> fixedLocations) {
        boolean  contains = getFixedLocations() != null && getFixedLocations().containsAll(fixedLocations);
        return contains;
    }

    public Set<Location> getFixedLocations() {
        return fixedLocations;
    }

    public void setFixedLocations(Set<Location> fixedLocations) {
        this.fixedLocations = fixedLocations;
    }

    public Supplier getSupplier() {
        return supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        T result = null;
        if (childs != null) {
            if (childs instanceof List) {
                if (index < childs.size()) {
                    result = ((List<T>) childs).get(index);
                }
            } else {
                int i = 0;
                for (T o : childs) {
                    if (index == i) {
                        result = o;
                        break;
                    }
                    i++;
                }
            }
        }
        return result;
    }

} //AbstractJpaArticle
