/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.franciaflex.faxtomail.web.action.DemandDetailAction;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaNoResultException;

@InterceptorRefs(value={@InterceptorRef(value="faxToMailInterceptor"), @InterceptorRef(value="paramsPrepareParamsStack")})
public class DemandDetailAction
extends FaxToMailActionSupport {
    private static final Log log = LogFactory.getLog(DemandDetailAction.class);
    protected EmailService emailService;
    protected DecoratorService decoratorService;
    protected String id;
    protected boolean original;
    protected int index;
    protected Email demand;
    protected int quotationTotal;
    protected int productTotal;
    protected int savTotal;
    protected EmailUIModel emailUIModel;
    protected InputStream attachmentFileInputStream;
    protected String fileName;
    protected String contentType;

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setDecoratorService(DecoratorService decoratorService) {
        this.decoratorService = decoratorService;
    }

    @Action(value="demand-detail")
    public String execute() throws Exception {
        String result = "success";
        try {
            this.demand = this.emailService.getEmailById(this.id);
            this.computeTotals();
            this.decomposeEmail();
        }
        catch (TopiaNoResultException e) {
            result = "error";
            this.addActionError(I18n.t((String)"faxtomail.demandDetail.noDemandForId", (Object[])new Object[]{this.id}));
        }
        return result;
    }

    @Action(value="attachment-download", results={@Result(name="success", type="stream", params={"contentType", "${contentType}", "inputName", "attachmentFileInputStream", "contentDisposition", "attachment;filename=\"${fileName}\"", "bufferSize", "1024"})})
    public String dlAttachment() throws Exception {
        AttachmentFile attachmentFile = this.emailService.getAttachmentFile(this.id, this.original);
        File file = attachmentFile.getFile();
        this.fileName = attachmentFile.getFilename();
        this.contentType = Files.probeContentType(file.toPath());
        this.attachmentFileInputStream = new FileInputStream(file);
        return "success";
    }

    @Action(value="reply-attachment-download", results={@Result(name="success", type="stream", params={"contentType", "${contentType}", "inputName", "attachmentFileInputStream", "contentDisposition", "attachment;filename=\"${fileName}\"", "bufferSize", "1024"})})
    public String dlReplyAttachment() throws Exception {
        ReplyContent replyContent = this.emailService.getReplyContent(this.id);
        MimeMessage message = new MimeMessage(null, (InputStream)new ByteArrayInputStream(replyContent.getSource()));
        EmailUIModel replyModel = new EmailUIModel();
        if (message.isMimeType("multipart/*")) {
            this.decomposeMultipartEmail((Part)message, replyModel);
        } else {
            Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
            String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
            replyModel.setPlainContent(content);
        }
        AttachmentFile attachmentFile = (AttachmentFile)replyModel.getAttachments().get(this.index);
        File file = attachmentFile.getFile();
        this.fileName = attachmentFile.getFilename();
        this.contentType = Files.probeContentType(file.toPath());
        this.attachmentFileInputStream = new FileInputStream(file);
        return "success";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOriginal(boolean original) {
        this.original = original;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Email getDemand() {
        return this.demand;
    }

    public int getQuotationTotal() {
        return this.quotationTotal;
    }

    public int getProductTotal() {
        return this.productTotal;
    }

    public int getSavTotal() {
        return this.savTotal;
    }

    public EmailUIModel getEmailUIModel() {
        return this.emailUIModel;
    }

    public InputStream getAttachmentFileInputStream() {
        return this.attachmentFileInputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<EmailUIModel> getReplies() throws Exception {
        Preconditions.checkNotNull((Object)this.demand);
        ArrayList<EmailUIModel> result = new ArrayList<EmailUIModel>();
        for (Reply reply : this.demand.getReplies()) {
            ReplyContent replyContent = reply.getReplyContent();
            MimeMessage message = new MimeMessage(null, (InputStream)new ByteArrayInputStream(replyContent.getSource()));
            EmailUIModel replyModel = new EmailUIModel();
            replyModel.setId(reply.getTopiaId());
            replyModel.setSubject(message.getSubject());
            String toRecipient = message.getRecipients(MimeMessage.RecipientType.TO)[0].toString();
            replyModel.setToRecipients((List)Lists.newArrayList((Object[])new String[]{toRecipient}));
            replyModel.setSender(message.getFrom()[0].toString());
            if (ArrayUtils.isNotEmpty((Object[])message.getRecipients(MimeMessage.RecipientType.CC))) {
                String ccRecipient = message.getRecipients(MimeMessage.RecipientType.CC)[0].toString();
                replyModel.setCcRecipients((List)Lists.newArrayList((Object[])new String[]{ccRecipient}));
            }
            if (ArrayUtils.isNotEmpty((Object[])message.getRecipients(MimeMessage.RecipientType.BCC))) {
                String bccRecipient = message.getRecipients(MimeMessage.RecipientType.BCC)[0].toString();
                replyModel.setBccRecipients((List)Lists.newArrayList((Object[])new String[]{bccRecipient}));
            }
            if (message.isMimeType("multipart/*")) {
                this.decomposeMultipartEmail((Part)message, replyModel);
            } else {
                Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
                String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                replyModel.setPlainContent(content);
            }
            result.add(replyModel);
        }
        return result;
    }

    public List<History> getHistories() {
        Preconditions.checkNotNull((Object)this.demand);
        ArrayList<History> result = new ArrayList<History>(this.demand.getHistory());
        Collections.sort(result, Ordering.natural().onResultOf((Function)new /* Unavailable Anonymous Inner Class!! */));
        return result;
    }

    public String decorate(Object o) {
        return this.decorate(o, "&nbsp;");
    }

    public String decorateUser(FaxToMailUser user) {
        return this.decorate((Object)user, I18n.t((String)"faxtomail.systemUser", (Object[])new Object[0]));
    }

    protected String decorate(Object o, String defaultValue) {
        String result = null;
        if (o != null) {
            Decorator decorator = this.decoratorService.getDecoratorByType(o.getClass());
            result = decorator != null ? decorator.toString(o) : o.toString();
        }
        result = StringUtils.isBlank(result) ? defaultValue : result.replaceAll("(\r\n|\n)", "<br />");
        return result;
    }

    protected void computeTotals() {
        this.quotationTotal = 0;
        this.productTotal = 0;
        this.savTotal = 0;
        if (this.demand != null && this.demand.getRangeRow() != null) {
            for (RangeRow row : this.demand.getRangeRow()) {
                if (row.getQuotationQuantity() != null) {
                    this.quotationTotal += row.getQuotationQuantity().intValue();
                }
                if (row.getProductQuantity() != null) {
                    this.productTotal += row.getProductQuantity().intValue();
                }
                if (row.getSavQuantity() == null) continue;
                this.savTotal += row.getSavQuantity().intValue();
            }
        }
    }

    protected void decomposeEmail() {
        block9: {
            this.emailUIModel = new EmailUIModel();
            try {
                OriginalEmail originalEmail = this.demand.getOriginalEmail();
                String originalEmailContent = originalEmail.getContent();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(originalEmailContent.getBytes(StandardCharsets.UTF_8));
                MimeMessage message = new MimeMessage(null, (InputStream)byteArrayInputStream);
                this.emailUIModel.setSubject(message.getSubject());
                ArrayList<String> toRecipients = new ArrayList<String>();
                ArrayList<String> ccRecipients = new ArrayList<String>();
                Address[] recipients = message.getRecipients(Message.RecipientType.TO);
                if (recipients != null) {
                    for (Address address : recipients) {
                        toRecipients.add(address.toString());
                    }
                }
                this.emailUIModel.setToRecipients(toRecipients);
                recipients = message.getRecipients(Message.RecipientType.CC);
                if (recipients != null) {
                    for (Address address : recipients) {
                        ccRecipients.add(address.toString());
                    }
                }
                this.emailUIModel.setCcRecipients(ccRecipients);
                if (message.isMimeType("multipart/*")) {
                    this.decomposeMultipartEmail((Part)message, this.emailUIModel);
                } else if (message.isMimeType("text/*")) {
                    Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
                    String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                    this.emailUIModel.setPlainContent(content);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void decomposeMultipartEmail(Part part, EmailUIModel emailUIModel) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            String[] header;
            BodyPart bp = mimeMultipart.getBodyPart(j);
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                Charset charset = FaxToMailServiceUtils.getCharset((Part)bp);
                String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                if (bp.isMimeType("text/plain")) {
                    emailUIModel.setPlainContent(content);
                    continue;
                }
                emailUIModel.setHtmlContent(content);
                continue;
            }
            if (bp.isMimeType("multipart/*")) {
                this.decomposeMultipartEmail((Part)bp, emailUIModel);
                continue;
            }
            String fileName = bp.getFileName();
            if (fileName == null && (header = bp.getHeader("Content-ID")) != null && header.length > 0) {
                fileName = header[0];
                fileName = fileName.replaceFirst("^<(.*)>$", "$1");
            }
            if (fileName == null) {
                fileName = I18n.t((String)"faxtomail.email.content.attachment.unnamed", (Object[])new Object[]{j});
            }
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            DataHandler dh = bp.getDataHandler();
            dh.writeTo((OutputStream)fos);
            AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
            attachmentFile.setContent(fos.toByteArray());
            attachmentFile.setFilename(fileName);
            emailUIModel.addAttachmentFile((AttachmentFile)attachmentFile);
        }
    }
}

