/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action.admin;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportResult;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.franciaflex.faxtomail.web.HasUploadedFile;
import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

@InterceptorRefs(value={@InterceptorRef(value="faxToMailInterceptor"), @InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="paramsPrepareParamsStack"), @InterceptorRef(value="faxToMailExecAndWait", params={"excludeMethods", "input,downloadImportErrorFile", "delay", "1000"})})
public class ImportArchiveAction
extends FaxToMailActionSupport
implements Preparable,
HasUploadedFile {
    private static final Log log = LogFactory.getLog(ImportArchiveAction.class);
    protected String attachmentBase;
    protected File archiveFile;
    protected String archiveFileFileName;
    protected String archiveFileContentType;
    protected FaxToMailApplicationContext applicationContext;
    protected ArchiveImportResult importResult;
    protected InputStream inputStream;
    protected String fileName;
    protected String contentType;

    public void setApplicationContext(FaxToMailApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void prepare() throws Exception {
        if (!this.getSession().isAdmin()) {
            throw new RuntimeException("Not authorized");
        }
    }

    @Action(value="import-archive-input")
    public String input() throws Exception {
        return super.input();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action(results={@Result(name="wait", location="/WEB-INF/content/admin/import-archive-wait.jsp"), @Result(name="*", type="chain", params={"actionName", "import-archive-input"})})
    public String execute() throws Exception {
        String result = "success";
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            if (StringUtils.isNotBlank((CharSequence)this.attachmentBase) && !new File(this.attachmentBase).isDirectory()) {
                this.getSession().addErrorMessages("Le r\u00e9pertoire de base des pi\u00e8ces jointes n'est pas un r\u00e9pertoire lisible !");
                return "error";
            }
            if (this.archiveFile == null) {
                this.getSession().addErrorMessages("Le fichier d'archive est obligatoire !");
                return "error";
            }
        }
        try (FaxToMailTopiaPersistenceContext persistenceContext = this.applicationContext.newPersistenceContext();){
            persistenceContext = this.applicationContext.newPersistenceContext();
            FaxToMailServiceContext serviceContext = this.applicationContext.newServiceContext(persistenceContext);
            EmailService emailService = serviceContext.getEmailService();
            try (FileInputStream is = new FileInputStream(this.archiveFile);){
                File file = StringUtils.isNotBlank((CharSequence)this.attachmentBase) ? new File(this.attachmentBase) : null;
                this.importResult = emailService.importArchive((InputStream)is, file);
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.importResult.getNbImportedArchives() + " imported archives"));
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import archive file", (Throwable)ex);
                }
                this.getSession().addErrorMessages("Erreur lors de l'import : " + ex.getMessage());
                result = "error";
            }
        }
        return result;
    }

    @Action(value="download-import-archive-errorfile", results={@Result(name="success", type="stream", params={"contentType", "${contentType}", "inputName", "inputStream", "contentDisposition", "attachment;filename=\"${fileName}\"", "bufferSize", "1024"})})
    public String downloadImportErrorFile() throws Exception {
        File file = new File(this.getApplicationConfig().getDataDirectory(), this.fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.fileName + " exists : " + file.exists()));
        }
        this.contentType = Files.probeContentType(file.toPath());
        this.inputStream = new FileInputStream(file);
        return "success";
    }

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public void setAttachmentBase(String attachmentBase) {
        this.attachmentBase = attachmentBase;
    }

    public String getArchiveFileFileName() {
        return this.archiveFileFileName;
    }

    public void setArchiveFileFileName(String archiveFileFileName) {
        this.archiveFileFileName = archiveFileFileName;
    }

    public String getArchiveFileContentType() {
        return this.archiveFileContentType;
    }

    public void setArchiveFileContentType(String archiveFileContentType) {
        this.archiveFileContentType = archiveFileContentType;
    }

    public ArchiveImportResult getImportResult() {
        return this.importResult;
    }

    public void setImportResult(ArchiveImportResult importResult) {
        this.importResult = importResult;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getUploadedFile() {
        return this.archiveFile;
    }

    public void setUploadedFile(File file) {
        this.archiveFile = file;
    }
}

